/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.shell;

import org.crsh.shell.AbstractCommandTestCase;

public class CommandTestCase
extends AbstractCommandTestCase {
    private final String no_ret = "class no_ret extends org.crsh.command.CRaSHCommand {\n@Command\npublic void main() {\n}\n}";

    public void testUnknownCommand() throws Exception {
        this.assertUnknownCommand("bilto");
    }

    public void testFailure() throws Exception {
        Throwable t = this.assertEvalError("fail");
    }

    public void testInvalid() throws Exception {
        this.assertUnknownCommand("invalid");
    }

    public void testSimple() throws Exception {
        CommandTestCase.assertEquals((String)"foo", (String)this.assertOk("echo foo"));
    }

    public void testSession() throws Exception {
        CommandTestCase.assertEquals((String)"null", (String)this.assertOk("attribute foo"));
        this.lifeCycle.setAttribute("foo", "bar");
        CommandTestCase.assertEquals((String)"bar", (String)this.assertOk("attribute foo"));
        this.lifeCycle.setAttribute("foo", null);
        CommandTestCase.assertEquals((String)"null", (String)this.assertOk("attribute foo"));
    }

    public void testInvokeNoRet() throws Exception {
        String foo = "class foo extends org.crsh.command.CRaSHCommand {\n@Command\npublic String main() {\nno_ret()\n}\n}";
        this.lifeCycle.setCommand("foo", foo);
        this.lifeCycle.setCommand("no_ret", "class no_ret extends org.crsh.command.CRaSHCommand {\n@Command\npublic void main() {\n}\n}");
        CommandTestCase.assertEquals((String)"", (String)this.assertOk("foo"));
    }

    public void testInvokeNoRetInScript() throws Exception {
        String foo = "no_ret()\n";
        this.lifeCycle.setCommand("foo", foo);
        this.lifeCycle.setCommand("no_ret", "class no_ret extends org.crsh.command.CRaSHCommand {\n@Command\npublic void main() {\n}\n}");
        CommandTestCase.assertEquals((String)"", (String)this.assertOk("foo"));
    }

    public void testInvoke() throws Exception {
        String foo = "class foo extends org.crsh.command.CRaSHCommand {\n@Command\npublic String main() {\necho 'bar'\n}\n}";
        this.lifeCycle.setCommand("foo", foo);
        CommandTestCase.assertEquals((String)"bar", (String)this.assertOk("foo"));
    }

    public void testInvokeInScript() throws Exception {
        String foo = "echo 'bar'\n";
        this.lifeCycle.setCommand("foo", foo);
        CommandTestCase.assertEquals((String)"bar", (String)this.assertOk("foo"));
    }

    public void testClosure() {
        String foo = "class foo extends org.crsh.command.CRaSHCommand {\n@Command\npublic void main() {\ndef closure = echo\nclosure 'bar'\n}\n}";
        this.lifeCycle.setCommand("foo", foo);
        CommandTestCase.assertEquals((String)"bar", (String)this.assertOk("foo"));
    }

    public void testFlush() {
        CommandTestCase.assertEquals((String)"foobar", (String)this.assertOk("echo -f 1 foo bar"));
        CommandTestCase.assertEquals((String)"bar", (String)this.evalOk("out << 'bar'; out.flush();"));
    }

    public void testResolveOut() {
        String resolve = "class resolve extends org.crsh.command.CRaSHCommand {\n@Command\npublic org.crsh.command.PipeCommand<Object, Object> main() {\nreturn new org.crsh.command.PipeCommand<Object, Object>() {\npublic void open() {\nout << 'HELLO'\n}\n}\n}\n}";
        this.lifeCycle.setCommand("resolve", resolve);
        CommandTestCase.assertEquals((String)"HELLO", (String)this.assertOk("resolve"));
    }
}

