/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.command;

import groovy.lang.Binding;
import groovy.lang.Closure;
import groovy.lang.MissingMethodException;
import groovy.lang.MissingPropertyException;
import groovy.lang.Script;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.runtime.InvokerInvocationException;
import org.crsh.SessionContext;
import org.crsh.cmdline.CommandCompletion;
import org.crsh.cmdline.Delimiter;
import org.crsh.cmdline.spi.ValueCompletion;
import org.crsh.command.CRaSHCommand;
import org.crsh.command.ClassDispatcher;
import org.crsh.command.CommandClosure;
import org.crsh.command.CommandInvoker;
import org.crsh.command.DescriptionFormat;
import org.crsh.command.InvocationContext;
import org.crsh.command.InvocationContextImpl;
import org.crsh.command.NoSuchCommandException;
import org.crsh.command.ScriptException;
import org.crsh.command.ShellCommand;
import org.crsh.io.ProducerContext;
import org.crsh.shell.impl.command.CRaSH;
import org.crsh.text.RenderPrintWriter;
import org.crsh.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GroovyScriptCommand
extends Script
implements ShellCommand,
CommandInvoker<Object, Object> {
    private LinkedList<InvocationContext<?>> stack = null;
    protected InvocationContext context = null;
    protected RenderPrintWriter out;
    private String[] args;
    private boolean piped;

    protected GroovyScriptCommand() {
    }

    public final void pushContext(InvocationContext<?> context) throws NullPointerException {
        if (context == null) {
            throw new NullPointerException();
        }
        if (this.stack == null) {
            this.stack = new LinkedList();
        }
        this.stack.addLast(this.context);
        this.context = context;
        this.out = context.getWriter();
    }

    public final InvocationContext<?> popContext() {
        if (this.stack == null || this.stack.isEmpty()) {
            throw new IllegalStateException("Cannot pop a context anymore from the stack");
        }
        InvocationContext context = this.context;
        this.context = this.stack.removeLast();
        this.out = this.context != null ? this.context.getWriter() : null;
        return context;
    }

    public final void eval(String s) throws ScriptException, IOException {
        InvocationContext<?> context = this.peekContext();
        CommandInvoker<?, ?> invoker = context.resolve(s);
        invoker.open(context);
        invoker.flush();
        invoker.close();
    }

    public final InvocationContext<?> peekContext() {
        return this.context;
    }

    @Override
    public final Class<Object> getProducedType() {
        return Object.class;
    }

    @Override
    public final Class<Object> getConsumedType() {
        return Object.class;
    }

    public final Object invokeMethod(String name, Object args) {
        try {
            return super.invokeMethod(name, args);
        }
        catch (MissingMethodException e) {
            if (this.context instanceof InvocationContext) {
                InvocationContext ic = this.context;
                CRaSH crash = (CRaSH)this.context.getSession().get("crash");
                if (crash != null) {
                    ShellCommand cmd;
                    try {
                        cmd = crash.getCommand(name);
                    }
                    catch (NoSuchCommandException ce) {
                        throw new InvokerInvocationException((Throwable)ce);
                    }
                    if (cmd != null) {
                        ClassDispatcher dispatcher = new ClassDispatcher(cmd, this);
                        return dispatcher.dispatch("", CommandClosure.unwrapArgs(args));
                    }
                }
            }
            throw e;
        }
    }

    public final Object getProperty(String property) {
        CRaSH crash;
        if ("out".equals(property)) {
            if (this.context instanceof InvocationContext) {
                return this.context.getWriter();
            }
            return null;
        }
        if ("context".equals(property)) {
            return this.context;
        }
        if (this.context instanceof InvocationContext && (crash = (CRaSH)this.context.getSession().get("crash")) != null) {
            try {
                ShellCommand cmd = crash.getCommand(property);
                if (cmd != null) {
                    return new ClassDispatcher(cmd, this);
                }
            }
            catch (NoSuchCommandException e) {
                throw new InvokerInvocationException((Throwable)e);
            }
        }
        try {
            return super.getProperty(property);
        }
        catch (MissingPropertyException e) {
            return null;
        }
    }

    @Override
    public final CommandCompletion complete(SessionContext context, String line) {
        return new CommandCompletion(Delimiter.EMPTY, ValueCompletion.create());
    }

    @Override
    public void setPiped(boolean piped) {
        this.piped = piped;
    }

    @Override
    public final String describe(String line, DescriptionFormat mode) {
        return null;
    }

    @Override
    public final void open(ProducerContext<Object> context) {
        Binding binding = new Binding(context.getSession());
        binding.setProperty("args", (Object)this.args);
        this.setBinding(binding);
        this.pushContext(new InvocationContextImpl<Object>(context));
        try {
            RenderPrintWriter writer;
            Object res = this.run();
            if (res instanceof Closure) {
                Closure closure = (Closure)res;
                res = closure.call((Object[])this.args);
            }
            if (res != null && (writer = this.peekContext().getWriter()).isEmpty()) {
                writer.print(res);
            }
        }
        catch (Exception t) {
            throw CRaSHCommand.toScript(t);
        }
    }

    @Override
    public final void provide(Object element) throws IOException {
    }

    @Override
    public final void flush() throws IOException {
        this.peekContext().flush();
    }

    @Override
    public final void close() {
        this.popContext();
    }

    @Override
    public final CommandInvoker<?, ?> resolveInvoker(String line) {
        List<String> chunks = Strings.chunks(line);
        this.args = chunks.toArray(new String[chunks.size()]);
        return this;
    }

    @Override
    public final CommandInvoker<?, ?> resolveInvoker(String name, Map<String, ?> options, List<?> args) {
        String[] tmp = new String[args.size()];
        for (int i = 0; i < tmp.length; ++i) {
            tmp[i] = args.get(i).toString();
        }
        this.args = tmp;
        return this;
    }
}

