/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.text.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.crsh.text.LineReader;
import org.crsh.text.RenderAppendable;
import org.crsh.text.Renderer;
import org.crsh.text.Style;
import org.crsh.text.ui.BorderStyle;
import org.crsh.text.ui.Element;
import org.crsh.text.ui.Layout;
import org.crsh.text.ui.RowElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RowRenderer
extends Renderer {
    private final List<Renderer> cols;
    private final Style.Composite style;
    final int leftCellPadding;
    final int rightCellPadding;
    private final BorderStyle separator;

    RowRenderer(RowElement row, BorderStyle separator, int leftCellPadding, int rightCellPadding) {
        ArrayList<Renderer> cols = new ArrayList<Renderer>(row.cols.size());
        for (Element col : row.cols) {
            cols.add(col.renderer());
        }
        this.cols = cols;
        this.style = row.getStyle();
        this.separator = separator;
        this.leftCellPadding = leftCellPadding;
        this.rightCellPadding = rightCellPadding;
    }

    int getSize() {
        return this.cols.size();
    }

    public List<Renderer> getCols() {
        return this.cols;
    }

    @Override
    public int getActualWidth() {
        int actualWidth = 0;
        for (int i = 0; i < this.cols.size(); ++i) {
            Renderer col = this.cols.get(i);
            actualWidth += col.getActualWidth();
            actualWidth += this.leftCellPadding;
            actualWidth += this.rightCellPadding;
            if (this.separator == null || i <= 0) continue;
            ++actualWidth;
        }
        return actualWidth;
    }

    @Override
    public int getMinWidth() {
        int minWidth = 0;
        for (int i = 0; i < this.cols.size(); ++i) {
            Renderer col = this.cols.get(i);
            minWidth += col.getMinWidth();
            minWidth += this.leftCellPadding;
            minWidth += this.rightCellPadding;
            if (this.separator == null || i <= 0) continue;
            ++minWidth;
        }
        return minWidth;
    }

    @Override
    public int getActualHeight(int width) {
        int actualHeight = 0;
        for (Renderer col : this.cols) {
            actualHeight = Math.max(actualHeight, col.getActualHeight(width));
        }
        return actualHeight;
    }

    @Override
    public int getMinHeight(int width) {
        int minHeight = 0;
        for (Renderer col : this.cols) {
            minHeight = Math.max(minHeight, col.getMinHeight(width));
        }
        return minHeight;
    }

    LineReader renderer(final int[] widths, int height) {
        final LineReader[] readers = new LineReader[widths.length];
        for (int i = 0; i < readers.length; ++i) {
            LineReader reader;
            Renderer renderer = this.cols.get(i);
            readers[i] = reader = renderer.reader(widths[i] - this.leftCellPadding - this.rightCellPadding, height);
        }
        return new LineReader(){
            private boolean done = false;

            public boolean hasLine() {
                return !this.done;
            }

            public void renderLine(RenderAppendable to) {
                if (!this.hasLine()) {
                    throw new IllegalStateException();
                }
                if (RowRenderer.this.style != null) {
                    to.enterStyle(RowRenderer.this.style);
                }
                for (int i = 0; i < readers.length; ++i) {
                    int j;
                    LineReader reader = readers[i];
                    if (i > 0 && RowRenderer.this.separator != null) {
                        to.styleOff();
                        to.append(((RowRenderer)RowRenderer.this).separator.vertical);
                        to.styleOn();
                    }
                    if (reader != null && reader.hasLine()) {
                        if (RowRenderer.this.leftCellPadding > 0) {
                            for (j = 0; j < RowRenderer.this.leftCellPadding; ++j) {
                                to.append(' ');
                            }
                        }
                        reader.renderLine(to);
                        if (RowRenderer.this.rightCellPadding <= 0) continue;
                        for (j = 0; j < RowRenderer.this.rightCellPadding; ++j) {
                            to.append(' ');
                        }
                        continue;
                    }
                    readers[i] = null;
                    for (j = widths[i]; j > 0; --j) {
                        to.append(' ');
                    }
                }
                if (RowRenderer.this.style != null) {
                    to.leaveStyle();
                }
                this.done = true;
                for (LineReader reader : readers) {
                    if (reader == null || !reader.hasLine()) continue;
                    this.done = false;
                    break;
                }
            }
        };
    }

    @Override
    public LineReader reader(int width) {
        int[] widths = new int[this.cols.size()];
        int[] minWidths = new int[this.cols.size()];
        for (int i = 0; i < this.cols.size(); ++i) {
            Renderer renderable = this.cols.get(i);
            widths[i] = Math.max(widths[i], renderable.getActualWidth());
            minWidths[i] = Math.max(minWidths[i], renderable.getMinWidth());
        }
        widths = Layout.flow().compute(false, width, widths, minWidths);
        if (widths == null) {
            return null;
        }
        widths = Arrays.copyOf(widths, minWidths.length);
        return this.renderer(widths, -1);
    }
}

