/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.crsh.util.BaseIterator;
import org.crsh.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CharSlicer {
    private final String value;
    private Pair<Integer, Integer> size;

    public CharSlicer(String value) {
        this.value = value;
        this.size = this.size();
    }

    public Pair<Integer, Integer> size() {
        if (this.size == null) {
            this.size = CharSlicer.size(this.value, 0, 1);
        }
        return this.size;
    }

    private static Pair<Integer, Integer> size(String s, int index, int height) {
        if (index < s.length()) {
            int pos = s.indexOf(10, index);
            if (pos == -1) {
                return Pair.of(s.length() - index, height);
            }
            Pair<Integer, Integer> ret = CharSlicer.size(s, pos + 1, height + 1);
            return new Pair<Integer, Integer>(Math.max(pos - index, ret.getFirst()), ret.getSecond());
        }
        return Pair.of(0, height);
    }

    public Pair<Integer, Integer>[] lines(int width) {
        return this.lines(this.linesIterator(width), 0);
    }

    private Pair<Integer, Integer>[] lines(Iterator<Pair<Integer, Integer>> i, int count) {
        Pair[] lines;
        if (i.hasNext()) {
            Pair<Integer, Integer> n = i.next();
            lines = this.lines(i, count + 1);
            lines[count] = n;
        } else {
            lines = new Pair[count];
        }
        return lines;
    }

    public Iterator<Pair<Integer, Integer>> linesIterator(final int width) {
        return new BaseIterator<Pair<Integer, Integer>>(){
            int index = 0;
            Pair<Integer, Integer> next = null;

            @Override
            public boolean hasNext() {
                if (this.next == null && this.index != Integer.MAX_VALUE) {
                    int pos = CharSlicer.this.value.indexOf(10, this.index);
                    int nextIndex = pos == -1 ? (pos = Math.min(this.index + width, CharSlicer.this.value.length())) : (pos <= this.index + width ? pos + 1 : (pos = this.index + width));
                    this.next = Pair.of(this.index, pos);
                    this.index = pos < CharSlicer.this.value.length() ? nextIndex : Integer.MAX_VALUE;
                }
                return this.next != null;
            }

            @Override
            public Pair<Integer, Integer> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Pair<Integer, Integer> next = this.next;
                this.next = null;
                return next;
            }
        };
    }
}

