/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InterruptHandler {
    private final Runnable runnable;
    private final Logger log = LoggerFactory.getLogger(InterruptHandler.class);
    private final InvocationHandler handler = new InvocationHandler(){

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Class<?>[] parameterTypes = method.getParameterTypes();
            if (method.getName().equals("hashCode") && parameterTypes.length == 0) {
                return System.identityHashCode(InterruptHandler.this.runnable);
            }
            if (method.getName().equals("equals") && parameterTypes.length == 1 && parameterTypes[0] == Object.class) {
                return InterruptHandler.this.runnable.equals(args[0]);
            }
            if (method.getName().equals("toString") && parameterTypes.length == 0) {
                return InterruptHandler.this.runnable.toString();
            }
            if (method.getName().equals("handle")) {
                InterruptHandler.this.runnable.run();
                return null;
            }
            throw new UnsupportedOperationException("Method " + method + " not implemented");
        }
    };

    public InterruptHandler(Runnable runnable) {
        this.runnable = runnable;
    }

    public void install() {
        Object INT;
        Method handle;
        Class<?> signalHandlerClass;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            signalHandlerClass = cl.loadClass("sun.misc.SignalHandler");
            Class<?> signalClass = cl.loadClass("sun.misc.Signal");
            handle = signalClass.getDeclaredMethod("handle", signalClass, signalHandlerClass);
            Constructor<?> ctor = signalClass.getConstructor(String.class);
            INT = ctor.newInstance("INT");
        }
        catch (Exception e) {
            return;
        }
        Object proxy = Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{signalHandlerClass}, this.handler);
        try {
            handle.invoke(null, INT, proxy);
        }
        catch (Exception e) {
            this.log.error("Could not install signal handler", (Throwable)e);
        }
    }
}

