/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.vfs.spi.jarurl;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import org.crsh.vfs.Path;
import org.crsh.vfs.spi.jarurl.JarURLDriver;

public class Handle {
    private final JarURLDriver driver;
    final Path path;
    Map<String, Handle> children;
    JarEntry entry;

    Handle(JarURLDriver driver, String path) {
        this.driver = driver;
        this.path = Path.get("/" + path);
        this.children = new HashMap<String, Handle>();
    }

    public boolean isDir() {
        return this.entry == null || this.entry.isDirectory();
    }

    public URL toURL() throws IllegalArgumentException, IllegalStateException, MalformedURLException {
        if (this.isDir()) {
            throw new IllegalStateException("Cannot create dir URL");
        }
        String file = this.driver.jarURL.toString() + "!/" + this.entry.getName();
        return new URL("jar", "", file);
    }
}

