/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.cmdline;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import org.crsh.cmdline.ArgumentDescriptor;
import org.crsh.cmdline.ClassDescriptor;
import org.crsh.cmdline.Description;
import org.crsh.cmdline.IntrospectionException;
import org.crsh.cmdline.MethodDescriptor;
import org.crsh.cmdline.OptionDescriptor;
import org.crsh.cmdline.ParameterDescriptor;
import org.crsh.cmdline.ParameterType;
import org.crsh.cmdline.annotations.Argument;
import org.crsh.cmdline.annotations.Command;
import org.crsh.cmdline.annotations.Option;
import org.crsh.cmdline.annotations.Required;
import org.crsh.cmdline.binding.ClassFieldBinding;
import org.crsh.cmdline.binding.MethodArgumentBinding;
import org.crsh.cmdline.binding.TypeBinding;
import org.crsh.cmdline.type.ValueTypeFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandFactory {
    public static final CommandFactory DEFAULT = new CommandFactory();
    private static final Logger log = LoggerFactory.getLogger(CommandFactory.class);
    private final ValueTypeFactory valueTypeFactory;

    private CommandFactory() {
        this.valueTypeFactory = ValueTypeFactory.DEFAULT;
    }

    public CommandFactory(ClassLoader loader) throws NullPointerException {
        this(new ValueTypeFactory(loader));
    }

    public CommandFactory(ValueTypeFactory valueTypeFactory) throws NullPointerException {
        if (valueTypeFactory == null) {
            throw new NullPointerException("No null value type factory accepted");
        }
        this.valueTypeFactory = valueTypeFactory;
    }

    private <T> List<MethodDescriptor<T>> commands(ClassDescriptor descriptor, Class<T> type, Class<?> introspected) throws IntrospectionException {
        List<MethodDescriptor<T>> commands;
        Class<?> superIntrospected = introspected.getSuperclass();
        if (superIntrospected == null) {
            commands = new ArrayList<MethodDescriptor<T>>();
        } else {
            commands = this.commands(descriptor, type, superIntrospected);
            for (Method m : introspected.getDeclaredMethods()) {
                MethodDescriptor<T> mDesc = this.create(descriptor, m);
                if (mDesc == null) continue;
                commands.add(mDesc);
            }
        }
        return commands;
    }

    public <T> ClassDescriptor<T> create(Class<T> type) throws IntrospectionException {
        LinkedHashMap methodMap = new LinkedHashMap();
        ClassDescriptor<T> descriptor = new ClassDescriptor<T>(type, methodMap, new Description(type));
        for (MethodDescriptor<T> methodDescriptor : this.commands(descriptor, type, type)) {
            methodMap.put(methodDescriptor.getName(), methodDescriptor);
        }
        for (ParameterDescriptor parameterDescriptor : this.parameters(type)) {
            descriptor.addParameter(parameterDescriptor);
        }
        return descriptor;
    }

    protected <B extends TypeBinding> ParameterDescriptor<B> create(B binding, Type type, Argument argumentAnn, Option optionAnn, boolean required, Description info, Annotation ann) throws IntrospectionException {
        if (argumentAnn != null) {
            if (optionAnn != null) {
                throw new IntrospectionException();
            }
            return new ArgumentDescriptor<B>(binding, argumentAnn.name(), ParameterType.create(this.valueTypeFactory, type), info, required, argumentAnn.password(), argumentAnn.unquote(), argumentAnn.completer(), ann);
        }
        if (optionAnn != null) {
            return new OptionDescriptor<B>(binding, ParameterType.create(this.valueTypeFactory, type), Collections.unmodifiableList(Arrays.asList(optionAnn.names())), info, required, optionAnn.password(), optionAnn.unquote(), optionAnn.completer(), ann);
        }
        return null;
    }

    protected static Tuple get(Annotation ... ab) {
        Argument argumentAnn = null;
        Option optionAnn = null;
        Boolean required = null;
        Description description = new Description(ab);
        Annotation info = null;
        for (Annotation parameterAnnotation : ab) {
            Required metaReq;
            if (parameterAnnotation instanceof Option) {
                optionAnn = (Option)parameterAnnotation;
                continue;
            }
            if (parameterAnnotation instanceof Argument) {
                argumentAnn = (Argument)parameterAnnotation;
                continue;
            }
            if (parameterAnnotation instanceof Required) {
                required = ((Required)parameterAnnotation).value();
                continue;
            }
            if (info != null) continue;
            Class<? extends Annotation> a = parameterAnnotation.annotationType();
            if (a.getAnnotation(Option.class) != null) {
                optionAnn = a.getAnnotation(Option.class);
                info = parameterAnnotation;
            } else if (a.getAnnotation(Argument.class) != null) {
                argumentAnn = a.getAnnotation(Argument.class);
                info = parameterAnnotation;
            }
            if (info == null) continue;
            description = new Description(description, new Description(a));
            if (required != null || (metaReq = a.getAnnotation(Required.class)) == null) continue;
            required = metaReq.value();
        }
        return new Tuple(argumentAnn, optionAnn, required != null && required != false, description, info);
    }

    public <T> MethodDescriptor<T> create(ClassDescriptor<T> owner, Method m) throws IntrospectionException {
        Command command = m.getAnnotation(Command.class);
        if (command != null) {
            Description info = new Description(m);
            MethodDescriptor<T> descriptor = new MethodDescriptor<T>(owner, m, m.getName().toLowerCase(), info);
            Type[] parameterTypes = m.getGenericParameterTypes();
            Annotation[][] parameterAnnotationMatrix = m.getParameterAnnotations();
            for (int i = 0; i < parameterAnnotationMatrix.length; ++i) {
                Annotation[] parameterAnnotations = parameterAnnotationMatrix[i];
                Type parameterType = parameterTypes[i];
                Tuple tuple = CommandFactory.get(parameterAnnotations);
                MethodArgumentBinding binding = new MethodArgumentBinding(i);
                ParameterDescriptor<MethodArgumentBinding> parameter = this.create(binding, parameterType, tuple.argumentAnn, tuple.optionAnn, tuple.required, tuple.descriptionAnn, tuple.ann);
                if (parameter != null) {
                    descriptor.addParameter(parameter);
                    continue;
                }
                log.debug("Method argument with index " + i + " of method " + m + " is not annotated");
            }
            return descriptor;
        }
        return null;
    }

    private List<ParameterDescriptor<ClassFieldBinding>> parameters(Class<?> introspected) throws IntrospectionException {
        ArrayList<ParameterDescriptor<ClassFieldBinding>> parameters;
        Class<?> superIntrospected = introspected.getSuperclass();
        if (superIntrospected == null) {
            parameters = new ArrayList();
        } else {
            parameters = this.parameters(superIntrospected);
            for (Field f : introspected.getDeclaredFields()) {
                Tuple tuple = CommandFactory.get(f.getAnnotations());
                ClassFieldBinding binding = new ClassFieldBinding(f);
                ParameterDescriptor<ClassFieldBinding> parameter = this.create(binding, f.getGenericType(), tuple.argumentAnn, tuple.optionAnn, tuple.required, tuple.descriptionAnn, tuple.ann);
                if (parameter == null) continue;
                parameters.add(parameter);
            }
        }
        return parameters;
    }

    protected static class Tuple {
        final Argument argumentAnn;
        final Option optionAnn;
        final boolean required;
        final Description descriptionAnn;
        final Annotation ann;

        private Tuple(Argument argumentAnn, Option optionAnn, boolean required, Description info, Annotation ann) {
            this.argumentAnn = argumentAnn;
            this.optionAnn = optionAnn;
            this.required = required;
            this.descriptionAnn = info;
            this.ann = ann;
        }
    }
}

