/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.shell.impl.command;

import java.io.IOException;
import org.crsh.command.CommandInvoker;
import org.crsh.command.ScriptException;
import org.crsh.command.SessionContext;
import org.crsh.io.Filter;
import org.crsh.io.ProducerContext;
import org.crsh.shell.impl.command.CRaSHSession;
import org.crsh.shell.impl.command.SinkPipeFilter;
import org.crsh.shell.impl.command.ToChunkPipeFilter;
import org.crsh.text.Chunk;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PipeLine
implements CommandInvoker {
    private final CRaSHSession session;
    private final Filter[] pipes;

    PipeLine(CRaSHSession session, Filter[] pipes) {
        this.session = session;
        this.pipes = pipes;
    }

    public void invoke(ProducerContext<?> context) throws ScriptException, IOException {
        this.open((ProducerContext)context);
        this.flush();
        this.close();
    }

    @Override
    public void setSession(SessionContext session) {
    }

    @Override
    public Class getConsumedType() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Class getProducedType() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setPiped(boolean piped) {
        throw new UnsupportedOperationException("This should not be called");
    }

    @Override
    public void open(ProducerContext context) {
        Filter last = context;
        for (int i = this.pipes.length - 1; i >= 0; --i) {
            Filter next;
            Class produced = this.pipes[i].getProducedType();
            Class consumed = last.getConsumedType();
            if (consumed.isAssignableFrom(produced)) {
                next = last;
            } else {
                Filter filter;
                if (produced.equals(Void.class)) {
                    throw new UnsupportedOperationException(produced.getSimpleName() + " -> " + consumed.getSimpleName());
                }
                if (consumed.equals(Void.class)) {
                    filter = new SinkPipeFilter(consumed);
                    ((SinkPipeFilter)filter).open(last);
                    next = filter;
                } else if (consumed.equals(Chunk.class)) {
                    filter = new ToChunkPipeFilter();
                    ((ToChunkPipeFilter)filter).open(last);
                    next = filter;
                } else {
                    filter = new SinkPipeFilter(consumed);
                    ((SinkPipeFilter)filter).open(last);
                    next = filter;
                }
            }
            if (i > 0) {
                this.pipes[i].setPiped(true);
            }
            this.pipes[i].open(next);
            last = this.pipes[i];
        }
    }

    @Override
    public void close() {
        this.pipes[0].close();
    }

    @Override
    public void provide(Object element) throws IOException {
        this.pipes[0].provide(element);
    }

    @Override
    public void flush() throws IOException {
        this.pipes[0].flush();
    }
}

