/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.util;

import java.util.concurrent.atomic.AtomicReference;
import junit.framework.TestCase;
import org.crsh.util.FutureListener;
import org.crsh.util.LatchedFuture;

public class LatchedFutureTestCase
extends TestCase {
    public void testBasic() throws Exception {
        LatchedFuture s = new LatchedFuture();
        LatchedFutureTestCase.assertFalse((boolean)s.isDone());
        s.set((Object)"foo");
        LatchedFutureTestCase.assertTrue((boolean)s.isDone());
        LatchedFutureTestCase.assertEquals((String)"foo", (String)((String)s.get()));
    }

    public void testListener1() throws Exception {
        LatchedFuture s = new LatchedFuture();
        final AtomicReference ref = new AtomicReference();
        s.addListener((FutureListener)new FutureListener<String>(){

            public void completed(String value) {
                ref.set(value);
            }
        });
        LatchedFutureTestCase.assertNull(ref.get());
        s.set((Object)"bar");
        LatchedFutureTestCase.assertEquals((String)"bar", (String)((String)ref.get()));
    }

    public void testListener2() throws Exception {
        LatchedFuture s = new LatchedFuture();
        s.set((Object)"bar");
        final AtomicReference ref = new AtomicReference();
        s.addListener((FutureListener)new FutureListener<String>(){

            public void completed(String value) {
                ref.set(value);
            }
        });
        LatchedFutureTestCase.assertEquals((String)"bar", (String)((String)ref.get()));
    }
}

