/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.term.console;

import java.io.IOException;
import java.util.LinkedList;
import org.crsh.term.CodeType;
import org.crsh.term.Term;
import org.crsh.term.TermEvent;
import org.crsh.term.console.TermIOBuffer;
import org.crsh.term.console.TermIOWriter;
import org.crsh.term.spi.TermIO;
import org.crsh.text.CLS;
import org.crsh.text.Chunk;
import org.crsh.text.Style;
import org.crsh.text.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsoleTerm
implements Term {
    private final Logger log = LoggerFactory.getLogger(ConsoleTerm.class);
    private final LinkedList<CharSequence> history = new LinkedList();
    private CharSequence historyBuffer = null;
    private int historyCursor = -1;
    private final TermIO io;
    private final TermIOBuffer buffer;
    private final TermIOWriter writer;

    public ConsoleTerm(TermIO io) {
        this.io = io;
        this.buffer = new TermIOBuffer(io);
        this.writer = new TermIOWriter(io);
    }

    public int getWidth() {
        return this.io.getWidth();
    }

    public int getHeight() {
        return this.io.getHeight();
    }

    public String getProperty(String name) {
        return this.io.getProperty(name);
    }

    public void setEcho(boolean echo) {
        this.buffer.setEchoing(echo);
    }

    public TermEvent read() throws IOException {
        block14: do {
            int code = this.io.read();
            CodeType type = this.io.decode(code);
            switch (type) {
                case CLOSE: {
                    return TermEvent.close();
                }
                case BACKSPACE: {
                    this.buffer.del();
                    break;
                }
                case UP: 
                case DOWN: {
                    CharSequence s;
                    int nextHistoryCursor = this.historyCursor + (type == CodeType.UP ? 1 : -1);
                    if (nextHistoryCursor < -1 || nextHistoryCursor >= this.history.size()) continue block14;
                    CharSequence charSequence = s = nextHistoryCursor == -1 ? this.historyBuffer : this.history.get(nextHistoryCursor);
                    while (this.buffer.moveRight()) {
                    }
                    CharSequence t = this.buffer.replace(s);
                    if (this.historyCursor == -1) {
                        this.historyBuffer = t;
                    }
                    if (nextHistoryCursor == -1) {
                        this.historyBuffer = null;
                    }
                    this.historyCursor = nextHistoryCursor;
                    break;
                }
                case RIGHT: {
                    this.buffer.moveRight();
                    break;
                }
                case LEFT: {
                    this.buffer.moveLeft();
                    break;
                }
                case BREAK: {
                    this.log.debug("Want to cancel evaluation");
                    this.buffer.clear();
                    return TermEvent.brk();
                }
                case CHAR: {
                    if (code >= 0 && code < 128) {
                        this.buffer.append((char)code);
                        break;
                    }
                    this.log.debug("Unhandled char " + code);
                    break;
                }
                case TAB: {
                    this.log.debug("Tab");
                    return TermEvent.complete(this.buffer.getBufferToCursor());
                }
                case BACKWARD_WORD: {
                    int cursor;
                    int pos;
                    for (pos = cursor = this.buffer.getCursor(); pos > 0 && this.buffer.charAt(pos - 1) == ' '; --pos) {
                    }
                    while (pos > 0 && this.buffer.charAt(pos - 1) != ' ') {
                        --pos;
                    }
                    if (pos >= cursor) break;
                    this.buffer.moveLeft(cursor - pos);
                    break;
                }
                case FORWARD_WORD: {
                    int cursor;
                    int pos;
                    int size = this.buffer.getSize();
                    for (pos = cursor = this.buffer.getCursor(); pos < size && this.buffer.charAt(pos) == ' '; ++pos) {
                    }
                    while (pos < size && this.buffer.charAt(pos) != ' ') {
                        ++pos;
                    }
                    if (pos <= cursor) break;
                    this.buffer.moveRight(pos - cursor);
                    break;
                }
                case BEGINNING_OF_LINE: {
                    int cursor = this.buffer.getCursor();
                    if (cursor <= 0) break;
                    this.buffer.moveLeft(cursor);
                    break;
                }
                case END_OF_LINE: {
                    int cursor = this.buffer.getSize() - this.buffer.getCursor();
                    if (cursor <= 0) break;
                    this.buffer.moveRight(cursor);
                    break;
                }
            }
        } while (!this.buffer.hasNext());
        this.historyCursor = -1;
        this.historyBuffer = null;
        CharSequence input = this.buffer.next();
        return TermEvent.readLine(input);
    }

    public Appendable getDirectBuffer() {
        return this.buffer;
    }

    public void addToHistory(CharSequence line) {
        this.history.addFirst(line);
    }

    public CharSequence getBuffer() {
        return this.buffer.getBufferToCursor();
    }

    public void flush() {
        try {
            this.io.flush();
        }
        catch (IOException e) {
            this.log.debug("Exception thrown during term flush()", (Throwable)e);
        }
    }

    public void close() {
        try {
            this.log.debug("Closing connection");
            this.io.flush();
            this.io.close();
        }
        catch (IOException e) {
            this.log.debug("Exception thrown during term close()", (Throwable)e);
        }
    }

    public void provide(Chunk element) throws IOException {
        if (element == null) {
            throw new NullPointerException("No null chunk accepted");
        }
        if (element instanceof Text) {
            Text textChunk = (Text)element;
            this.writer.write(textChunk.getText());
        } else if (element instanceof Style) {
            this.io.write((Style)element);
        } else if (element instanceof CLS) {
            this.io.cls();
        } else {
            throw new UnsupportedOperationException("todo");
        }
    }
}

