/*
 * Decompiled with CFR 0.152.
 */
package org.crsh;

import java.io.IOException;
import java.util.LinkedList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import junit.framework.Assert;
import org.crsh.AbstractTestCase;
import org.crsh.shell.Shell;
import org.crsh.shell.ShellProcess;
import org.crsh.shell.ShellProcessContext;
import org.crsh.shell.ShellResponse;
import org.crsh.text.Chunk;
import org.crsh.text.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseProcessContext
implements ShellProcessContext {
    private final LinkedList<String> output = new LinkedList();
    private final LinkedList<String> input = new LinkedList();
    private ShellResponse response;
    private final CountDownLatch latch;
    private int width;
    private int height;
    private ShellProcess process;

    public static BaseProcessContext create(Shell shell, String line) {
        return new BaseProcessContext(shell, line);
    }

    public static BaseProcessContext create(ShellProcess process) {
        return new BaseProcessContext(process);
    }

    private BaseProcessContext(ShellProcess process) {
        this.process = process;
        this.latch = new CountDownLatch(1);
        this.response = null;
        this.width = 32;
        this.height = 40;
    }

    private BaseProcessContext(Shell shell, String line) {
        this(shell.createProcess(line));
    }

    public BaseProcessContext cancel() {
        this.process.cancel();
        return this;
    }

    public BaseProcessContext execute() {
        this.process.execute((ShellProcessContext)this);
        return this;
    }

    public ShellProcess getProcess() {
        return this.process;
    }

    public BaseProcessContext addLineInput(String line) {
        this.input.add(line);
        return this;
    }

    public BaseProcessContext assertLineOutput(String expected) {
        Assert.assertTrue((this.output.size() > 0 ? 1 : 0) != 0);
        String test = this.output.removeFirst();
        Assert.assertEquals((String)expected, (String)test);
        return this;
    }

    public BaseProcessContext assertNoOutput() {
        Assert.assertEquals((int)0, (int)this.output.size());
        return this;
    }

    public BaseProcessContext assertNoInput() {
        Assert.assertEquals((int)0, (int)this.input.size());
        return this;
    }

    public boolean takeAlternateBuffer() {
        return false;
    }

    public boolean releaseAlternateBuffer() {
        return false;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public String getProperty(String name) {
        return null;
    }

    public String readLine(String msg, boolean echo) {
        this.output.addLast(msg);
        return this.input.isEmpty() ? null : this.input.removeLast();
    }

    public Class<Chunk> getConsumedType() {
        return Chunk.class;
    }

    public void provide(Chunk element) throws IOException {
        CharSequence seq;
        if (element instanceof Text && (seq = ((Text)element).getText()).length() > 0) {
            this.output.add(((Object)seq).toString());
        }
    }

    public String getOutput() {
        StringBuilder buffer = new StringBuilder();
        for (String o : this.output) {
            buffer.append(o);
        }
        return buffer.toString();
    }

    public void flush() {
    }

    public void end(ShellResponse response) {
        this.response = response;
        this.latch.countDown();
    }

    public ShellResponse getResponse() {
        try {
            this.latch.await(60L, TimeUnit.SECONDS);
            return this.response;
        }
        catch (InterruptedException e) {
            throw AbstractTestCase.failure(e);
        }
    }
}

