/*
 * Decompiled with CFR 0.152.
 */
package org.crsh;

import java.util.HashMap;
import org.crsh.command.CRaSHCommand;
import org.crsh.plugin.CRaSHPlugin;
import org.crsh.plugin.PluginContext;
import org.crsh.plugin.PluginDiscovery;
import org.crsh.plugin.PluginLifeCycle;
import org.crsh.plugin.PropertyDescriptor;
import org.crsh.plugin.ServiceLoaderDiscovery;
import org.crsh.plugin.SimplePluginDiscovery;
import org.crsh.shell.impl.command.CRaSH;
import org.crsh.shell.impl.command.CRaSHSession;
import org.crsh.vfs.FS;
import org.crsh.vfs.Path;
import org.crsh.vfs.spi.FSDriver;
import org.crsh.vfs.spi.ram.RAMDriver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestPluginLifeCycle
extends PluginLifeCycle {
    private final PluginContext context;
    private CRaSH crash;
    private HashMap<String, Object> attributes = new HashMap();
    private final RAMDriver commands = new RAMDriver();

    public TestPluginLifeCycle() throws Exception {
        this(Thread.currentThread().getContextClassLoader());
    }

    public TestPluginLifeCycle(ClassLoader classLoader) throws Exception {
        this((PluginDiscovery)new ServiceLoaderDiscovery(classLoader), classLoader);
    }

    public TestPluginLifeCycle(CRaSHPlugin ... plugins) throws Exception {
        this((PluginDiscovery)new SimplePluginDiscovery(plugins), Thread.currentThread().getContextClassLoader());
    }

    private TestPluginLifeCycle(PluginDiscovery discovery, ClassLoader classLoader) throws Exception {
        this.context = new PluginContext(discovery, this.attributes, new FS().mount(classLoader, Path.get((String)"/crash/commands/")).mount((FSDriver)this.commands), new FS().mount(classLoader, Path.get((String)"/crash/")), classLoader);
        this.crash = new CRaSH(this.context);
    }

    public void bind(String name, String command) {
        if (name.contains("/")) {
            throw new IllegalArgumentException("Command name must not contain /");
        }
        if (name.contains(".")) {
            throw new IllegalArgumentException("Command name must not contain .");
        }
        this.commands.add(Path.get((String)("/" + name + ".groovy")), command);
        this.context.refresh();
    }

    public void bind(String name, Class<? extends CRaSHCommand> command) {
        if (name.contains("/")) {
            throw new IllegalArgumentException("Command name must not contain /");
        }
        if (name.contains(".")) {
            throw new IllegalArgumentException("Command name must not contain .");
        }
        this.commands.add(Path.get((String)("/" + name + ".groovy")), "public class " + name + " extends " + command.getName() + "{}");
        this.context.refresh();
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public void setAttribute(String name, Object value) {
        if (value != null) {
            this.attributes.put(name, value);
        } else {
            this.attributes.remove(name);
        }
    }

    public <T> void setProperty(PropertyDescriptor<T> desc, T value) throws NullPointerException {
        this.context.setProperty(desc, value);
    }

    public void start() {
        this.context.refresh();
        this.start(this.context);
    }

    public CRaSHSession createShell() {
        return this.crash.createSession(null);
    }
}

