/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.shell.impl.command;

import junit.framework.TestCase;
import org.crsh.command.SyntaxException;
import org.crsh.shell.impl.command.PipeLineFactory;
import org.crsh.shell.impl.command.PipeLineParser;

public class ParserTestCase
extends TestCase {
    public void testEmpty() {
        ParserTestCase.assertNull((Object)new PipeLineParser((CharSequence)"").parse());
    }

    public void testCommand() {
        PipeLineParser p = new PipeLineParser((CharSequence)"a");
        PipeLineFactory e = p.parse();
        ParserTestCase.assertEquals((String)"a", (String)e.line);
        ParserTestCase.assertNull((Object)e.next);
    }

    public void testPipe() {
        PipeLineParser p = new PipeLineParser((CharSequence)"a|b");
        PipeLineFactory e = p.parse();
        ParserTestCase.assertEquals((String)"a", (String)e.line);
        ParserTestCase.assertEquals((String)"b", (String)e.next.line);
        ParserTestCase.assertNull((Object)e.next.next);
    }

    public void testSyntaxException() {
        this.assertSyntaxException("|");
        this.assertSyntaxException("a|");
    }

    private void assertSyntaxException(String s) {
        try {
            new PipeLineParser((CharSequence)s).parse();
            ParserTestCase.fail();
        }
        catch (SyntaxException syntaxException) {
            // empty catch block
        }
    }
}

