/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.text.ui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.crsh.AbstractTestCase;
import org.crsh.shell.ScreenContext;
import org.crsh.text.Chunk;
import org.crsh.text.ChunkBuffer;
import org.crsh.text.LineReader;
import org.crsh.text.RenderAppendable;
import org.crsh.text.ui.Element;
import org.crsh.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRendererTestCase
extends AbstractTestCase {
    public List<String> render(LineReader renderer, final int width) {
        ArrayList<String> result = new ArrayList<String>();
        while (renderer.hasLine()) {
            final ChunkBuffer buffer = new ChunkBuffer();
            renderer.renderLine(new RenderAppendable((ScreenContext)new ScreenContext<Chunk>(){

                public int getWidth() {
                    return width;
                }

                public int getHeight() {
                    return 40;
                }

                public Class<Chunk> getConsumedType() {
                    return Chunk.class;
                }

                public void provide(Chunk element) throws IOException {
                    buffer.provide(element);
                }

                public void flush() throws IOException {
                    buffer.flush();
                }
            }));
            StringBuilder sb = new StringBuilder();
            try {
                buffer.writeAnsiTo((Appendable)sb);
            }
            catch (IOException e) {
                throw AbstractRendererTestCase.failure(e);
            }
            result.add(sb.toString());
        }
        return result;
    }

    public List<String> render(Element element, int width) {
        LineReader renderer = element.renderer().reader(width);
        return this.render(renderer, width);
    }

    public void assertRender(Element element, int width, int height, String ... expected) {
        LineReader renderer = element.renderer().reader(width, height);
        AbstractRendererTestCase.assertNotNull((String)"Was expecting a renderer", (Object)renderer);
        this.assertRender(renderer, width, expected);
    }

    public void assertRender(Element element, int width, String ... expected) {
        LineReader renderer = element.renderer().reader(width);
        AbstractRendererTestCase.assertNotNull((String)"Was expecting a renderer", (Object)renderer);
        this.assertRender(renderer, width, expected);
    }

    public void assertNoRender(Element element, int width) {
        LineReader renderer = element.renderer().reader(width);
        AbstractRendererTestCase.assertNull((Object)renderer);
    }

    public void assertNoRender(Element element, int width, int height) {
        LineReader renderer = element.renderer().reader(width, height);
        AbstractRendererTestCase.assertNull((Object)renderer);
    }

    public void assertRender(LineReader renderer, int width, String ... expected) {
        List<String> result = this.render(renderer, width);
        if (result.size() != expected.length) {
            throw AbstractRendererTestCase.failure("Was expecting the same number of lines got:" + Strings.join(result, (String)"/") + " expected:" + Strings.join(Arrays.asList(expected), (String)"/"));
        }
        for (int i = 0; i < expected.length; ++i) {
            if (result.get(i).equals(expected[i])) continue;
            throw AbstractRendererTestCase.failure("Was expecting line " + i + " <" + result.get(i) + "> to be equals to <" + expected[i] + ">");
        }
    }
}

