/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.text.ui;

import org.crsh.text.Color;
import org.crsh.text.ui.AbstractRendererTestCase;
import org.crsh.text.ui.BorderStyle;
import org.crsh.text.ui.Element;
import org.crsh.text.ui.TableElement;
import org.crsh.text.ui.TreeElement;

public class TableElementTestCase
extends AbstractRendererTestCase {
    public void testSimple() throws Exception {
        TableElement tableElement = new TableElement();
        tableElement.add(Element.row().add(new Element[]{Element.label((String)"a")}).add(new Element[]{Element.label((String)"b")})).add(Element.row().add(new Element[]{Element.label((String)"c")}).add(new Element[]{Element.label((String)"d")}));
        this.assertRender((Element)tableElement, 12, "ab          ", "cd          ");
    }

    public void testStyle() throws Exception {
        TableElement tableElement = new TableElement();
        tableElement.add(Element.row().style(Color.green.bg().fg(Color.blue).bold()).add(new Element[]{Element.label((String)"a")}).add(new Element[]{Element.label((String)"b")})).add(Element.row().add(new Element[]{Element.label((String)"c").style(Color.green.bg().fg(Color.blue).bold())}).add(new Element[]{Element.label((String)"d")}));
    }

    public void testInNode() throws Exception {
        TableElement tableElement = new TableElement();
        tableElement.add(Element.row().add(new Element[]{Element.label((String)"a")}).add(new Element[]{Element.label((String)"b")})).add(Element.row().add(new Element[]{Element.label((String)"c")}).add(new Element[]{Element.label((String)"d")}));
        TreeElement node = new TreeElement();
        node.addChild((Element)Element.label((String)"foo"));
        node.addChild((Element)tableElement);
        node.addChild((Element)Element.label((String)"bar"));
        this.assertRender((Element)node, 14, "+-foo         ", "+-ab          ", "| cd          ", "+-bar         ");
    }

    public void testInNodeBorder() throws Exception {
        TableElement tableElement = new TableElement(new int[]{1, 1});
        tableElement.border(BorderStyle.DASHED);
        tableElement.add(Element.row().add(new Element[]{Element.label((String)"a")}).add(new Element[]{Element.label((String)"b")})).add(Element.row().add(new Element[]{Element.label((String)"c")}).add(new Element[]{Element.label((String)"d")}));
        TreeElement node = new TreeElement();
        node.addChild((Element)Element.label((String)"foo"));
        node.addChild((Element)tableElement);
        node.addChild((Element)Element.label((String)"bar"));
        this.assertRender((Element)node, 32, "+-foo                           ", "+- ---------------------------- ", "| |a             b             |", "| |c             d             |", "|  ---------------------------- ", "+-bar                           ");
    }

    public void testInNodeTooLarge() throws Exception {
        TableElement tableElement = new TableElement();
        tableElement.add(Element.row().add(new Element[]{Element.label((String)"a")}).add(new Element[]{Element.label((String)"b")}).add(new Element[]{Element.label((String)"c is a very very very too long value")})).add(Element.row().add(new Element[]{Element.label((String)"d")}).add(new Element[]{Element.label((String)"e")}).add(new Element[]{Element.label((String)"f")}));
        TreeElement node = new TreeElement();
        node.addChild((Element)Element.label((String)"foo"));
        node.addChild((Element)tableElement);
        node.addChild((Element)Element.label((String)"bar"));
        this.assertRender((Element)node, 24, "+-foo                   ", "+-abc is a very very ver", "|   y too long value    ", "| def                   ", "+-bar                   ");
    }

    public void testInNodeTooLargeBorder() throws Exception {
        TableElement tableElement = new TableElement();
        tableElement.border(BorderStyle.DASHED);
        tableElement.separator(BorderStyle.DASHED);
        tableElement.add(Element.row().add(new Element[]{Element.label((String)"a")}).add(new Element[]{Element.label((String)"b")}).add(new Element[]{Element.label((String)"c is a very very very too long value")})).add(Element.row().add(new Element[]{Element.label((String)"d")}).add(new Element[]{Element.label((String)"e")}).add(new Element[]{Element.label((String)"f")}));
        TreeElement node = new TreeElement();
        node.addChild((Element)Element.label((String)"foo"));
        node.addChild((Element)tableElement);
        node.addChild((Element)Element.label((String)"bar"));
        this.assertRender((Element)node, 32, "+-foo                           ", "+- ---------------------------- ", "| |a|b|c is a very very very to|", "| | | |o long value            |", "| |d|e|f                       |", "|  ---------------------------- ", "+-bar                           ");
    }

    public void testInNodeHeader() throws Exception {
        TableElement tableElement = new TableElement().border(BorderStyle.DASHED);
        tableElement.add(Element.row().add(new Element[]{Element.label((String)"a")}).add(new Element[]{Element.label((String)"b")})).add(Element.row().add(new Element[]{Element.label((String)"c")}).add(new Element[]{Element.label((String)"d")})).add(Element.header().add(new Element[]{Element.label((String)"e")}).add(new Element[]{Element.label((String)"f")})).add(Element.row().add(new Element[]{Element.label((String)"g")}).add(new Element[]{Element.label((String)"h")})).add(Element.row().add(new Element[]{Element.label((String)"i")}).add(new Element[]{Element.label((String)"j")}));
        TreeElement node = new TreeElement();
        node.addChild((Element)Element.label((String)"foo"));
        node.addChild((Element)tableElement);
        node.addChild((Element)Element.label((String)"bar"));
        this.assertRender((Element)node, 32, "+-foo                           ", "+- --                           ", "| |ab|                          ", "| |cd|                          ", "|  --                           ", "| |ef|                          ", "|  --                           ", "| |gh|                          ", "| |ij|                          ", "|  --                           ", "+-bar                           ");
    }

    public void testTooLarge() throws Exception {
        TableElement tableElement = new TableElement();
        tableElement.add(Element.row().add(new Element[]{Element.label((String)"a")}).add(new Element[]{Element.label((String)"This text is very ver very too large to be displayed in a cell of 32")})).add(Element.row().add(new Element[]{Element.label((String)"c")}).add(new Element[]{Element.label((String)"d")}));
        this.assertRender((Element)tableElement, 27, "aThis text is very ver very", "  too large to be displayed", "  in a cell of 32          ", "cd                         ");
    }

    public void testSimpleBorder() throws Exception {
        TableElement tableElement = new TableElement();
        tableElement.add(Element.row().add(new Element[]{Element.label((String)"a")}).add(new Element[]{Element.label((String)"b")})).add(Element.row().add(new Element[]{Element.label((String)"c")}).add(new Element[]{Element.label((String)"d")}));
        tableElement.border(BorderStyle.DASHED);
        this.assertRender((Element)tableElement, 32, " --                             ", "|ab|                            ", "|cd|                            ", " --                             ");
        tableElement.border(BorderStyle.STAR);
        tableElement.separator(BorderStyle.STAR);
        this.assertRender((Element)tableElement, 32, "*****                           ", "*a*b*                           ", "*c*d*                           ", "*****                           ");
    }

    public void testBorderHeaderTopBottom() throws Exception {
        TableElement tableElement = new TableElement();
        tableElement.border(BorderStyle.DASHED);
        tableElement.add(Element.header().add(new Element[]{Element.label((String)"a")}).add(new Element[]{Element.label((String)"b")})).add(Element.row().add(new Element[]{Element.label((String)"c")}).add(new Element[]{Element.label((String)"d")})).add(Element.row().add(new Element[]{Element.label((String)"e")}).add(new Element[]{Element.label((String)"f")})).add(Element.header().add(new Element[]{Element.label((String)"g")}).add(new Element[]{Element.label((String)"h")}));
        this.assertRender((Element)tableElement, 32, " --                             ", "|ab|                            ", " --                             ", "|cd|                            ", "|ef|                            ", " --                             ", "|gh|                            ", " --                             ");
    }

    public void testNoBorderHeaderTopBottom() throws Exception {
        TableElement tableElement = new TableElement();
        tableElement.border(null);
        tableElement.add(Element.header().add(new Element[]{Element.label((String)"a")}).add(new Element[]{Element.label((String)"b")})).add(Element.row().add(new Element[]{Element.label((String)"c")}).add(new Element[]{Element.label((String)"d")})).add(Element.row().add(new Element[]{Element.label((String)"e")}).add(new Element[]{Element.label((String)"f")}));
        this.assertRender((Element)tableElement, 3, "ab ", "-- ", "cd ", "ef ");
    }

    public void testBorderHeaderMiddle() throws Exception {
        TableElement tableElement = new TableElement();
        tableElement.border(BorderStyle.DASHED);
        tableElement.add(Element.row().add(new Element[]{Element.label((String)"a")}).add(new Element[]{Element.label((String)"b")})).add(Element.row().add(new Element[]{Element.label((String)"c")}).add(new Element[]{Element.label((String)"d")})).add(Element.header().add(new Element[]{Element.label((String)"e")}).add(new Element[]{Element.label((String)"f")})).add(Element.row().add(new Element[]{Element.label((String)"g")}).add(new Element[]{Element.label((String)"h")})).add(Element.row().add(new Element[]{Element.label((String)"i")}).add(new Element[]{Element.label((String)"j")}));
        this.assertRender((Element)tableElement, 32, " --                             ", "|ab|                            ", "|cd|                            ", " --                             ", "|ef|                            ", " --                             ", "|gh|                            ", "|ij|                            ", " --                             ");
    }

    public void testBorderHeaderTwoMiddle() throws Exception {
        TableElement tableElement = new TableElement();
        tableElement.border(BorderStyle.DASHED);
        tableElement.add(Element.row().add(new Element[]{Element.label((String)"a")}).add(new Element[]{Element.label((String)"b")})).add(Element.row().add(new Element[]{Element.label((String)"c")}).add(new Element[]{Element.label((String)"d")})).add(Element.header().add(new Element[]{Element.label((String)"e")}).add(new Element[]{Element.label((String)"f")})).add(Element.header().add(new Element[]{Element.label((String)"g")}).add(new Element[]{Element.label((String)"h")})).add(Element.row().add(new Element[]{Element.label((String)"i")}).add(new Element[]{Element.label((String)"j")})).add(Element.row().add(new Element[]{Element.label((String)"k")}).add(new Element[]{Element.label((String)"l")}));
        this.assertRender((Element)tableElement, 32, " --                             ", "|ab|                            ", "|cd|                            ", " --                             ", "|ef|                            ", " --                             ", "|gh|                            ", " --                             ", "|ij|                            ", "|kl|                            ", " --                             ");
    }

    public void testTooLargeBorder() throws Exception {
        TableElement tableElement = new TableElement();
        tableElement.border(BorderStyle.DASHED);
        tableElement.separator(BorderStyle.DASHED);
        tableElement.add(Element.row().add(new Element[]{Element.label((String)"a")}).add(new Element[]{Element.label((String)"This text is very ver very too large to be displayed in a cell of 32")})).add(Element.row().add(new Element[]{Element.label((String)"c")}).add(new Element[]{Element.label((String)"d")}));
        this.assertRender((Element)tableElement, 32, " ------------------------------ ", "|a|This text is very ver very t|", "| |oo large to be displayed in |", "| |a cell of 32                |", "|c|d                           |", " ------------------------------ ");
    }

    public void testTooLargeBorderHeader() throws Exception {
        TableElement tableElement = new TableElement();
        tableElement.border(BorderStyle.DASHED);
        tableElement.separator(BorderStyle.DASHED);
        tableElement.add(Element.header().add(new Element[]{Element.label((String)"a")}).add(new Element[]{Element.label((String)"This text is very ver very too large to be displayed in a cell of 32")})).add(Element.row().add(new Element[]{Element.label((String)"c")}).add(new Element[]{Element.label((String)"d")}));
        this.assertRender((Element)tableElement, 32, " ------------------------------ ", "|a|This text is very ver very t|", "| |oo large to be displayed in |", "| |a cell of 32                |", " ------------------------------ ", "|c|d                           |", " ------------------------------ ");
    }

    public void testBorderStyle() throws Exception {
        TableElement tableElement = new TableElement();
        tableElement.border(BorderStyle.DASHED);
        tableElement.add(Element.row().style(Color.green.bg().fg(Color.blue).bold()).add(new Element[]{Element.label((String)"a")}).add(new Element[]{Element.label((String)"b")})).add(Element.row().add(new Element[]{Element.label((String)"c").style(Color.green.bg().fg(Color.blue).bold())}).add(new Element[]{Element.label((String)"d")}));
    }

    public void testTooManyColumns() throws Exception {
        TableElement tableElement = new TableElement();
        tableElement.separator(BorderStyle.DASHED);
        tableElement.border(BorderStyle.DASHED);
        tableElement.add(Element.row().add(new Element[]{Element.label((String)"a")}).add(new Element[]{Element.label((String)"This text is very ver very too large to be displayed in a cell of 32")}).add(new Element[]{Element.label((String)"b")}));
        this.assertRender((Element)tableElement, 32, " ------------------------------ ", "|a|This text is very ver very t|", "| |oo large to be displayed in |", "| |a cell of 32                |", " ------------------------------ ");
    }
}

