/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.TestCase;
import org.crsh.util.Utils;

public class UtilsTestCase
extends TestCase {
    public void testGlobexToRegex() throws Exception {
        this.assertMatchGlob("foo", "foo");
        this.assertNotMatchGlob("bar", "foo");
        this.assertMatchGlob("foo", "*foo");
        this.assertMatchGlob("barfoo", "*foo");
        this.assertNotMatchGlob("bar", "*foo");
        this.assertMatchGlob("foo", "foo*");
        this.assertMatchGlob("foobar", "foo*");
        this.assertNotMatchGlob("bar", "foo*");
        this.assertMatchGlob("fo", "f*o");
        this.assertMatchGlob("foo", "f*o");
        this.assertMatchGlob("fbo", "f*o");
        this.assertNotMatchGlob("bar", "f*o");
        this.assertNotMatchGlob("foo", "?foo");
        this.assertMatchGlob("afoo", "?foo");
        this.assertNotMatchGlob("abfoo", "?foo");
        this.assertNotMatchGlob("foo", "foo?");
        this.assertMatchGlob("fooa", "foo?");
        this.assertNotMatchGlob("fooab", "foo?");
        this.assertNotMatchGlob("fo", "f?o");
        this.assertMatchGlob("foo", "f?o");
        this.assertMatchGlob("fao", "f?o");
        this.assertNotMatchGlob("fabo", "f?o");
        this.assertMatchGlob("foo", "f[oa]o");
        this.assertMatchGlob("fao", "f[oa]o");
        this.assertNotMatchGlob("fo", "f[oa]o");
        this.assertNotMatchGlob("fooo", "f[oa]o");
        this.assertMatchGlob("*", "\\*");
        this.assertMatchGlob("?", "\\?");
        this.assertMatchGlob("[]", "\\[]");
        this.assertMatchGlob("f*o", "f[*]o");
        this.assertMatchGlob("f?o", "f[?]o");
    }

    private void assertMatchGlob(String test, String globex) {
        Pattern p = Pattern.compile("^" + Utils.globexToRegex((String)globex) + "$");
        Matcher matcher = p.matcher(test);
        UtilsTestCase.assertTrue((String)("Was expecting " + test + " to match " + globex), (boolean)matcher.matches());
    }

    private void assertNotMatchGlob(String test, String globex) {
        Pattern p = Pattern.compile("^" + Utils.globexToRegex((String)globex) + "$");
        Matcher matcher = p.matcher(test);
        UtilsTestCase.assertFalse((String)("Was expecting " + test + " to not match " + globex), (boolean)matcher.matches());
    }
}

