/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.standalone;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Logger;
import org.crsh.plugin.PluginContext;
import org.crsh.plugin.PluginLifeCycle;
import org.crsh.plugin.ServiceLoaderDiscovery;
import org.crsh.vfs.FS;
import org.crsh.vfs.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Bootstrap
extends PluginLifeCycle {
    protected final Logger log = Logger.getLogger(this.getClass().getName());
    private final FS confFS = new FS();
    private final FS cmdFS = new FS();
    private final ClassLoader loader;
    private Map<String, Object> attributes;

    public Bootstrap(ClassLoader baseLoader) throws NullPointerException {
        if (baseLoader == null) {
            throw new NullPointerException("No null base loader accepted");
        }
        this.attributes = Collections.emptyMap();
        this.loader = new URLClassLoader(new URL[0], baseLoader);
    }

    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    public Bootstrap addToConfPath(File path) throws NullPointerException, IOException {
        if (path == null) {
            throw new NullPointerException("No null conf path");
        }
        this.log.info("Added " + path.getCanonicalPath() + " command to conf path");
        this.confFS.mount(path);
        return this;
    }

    public Bootstrap addToConfPath(Path path) throws NullPointerException, IOException, URISyntaxException {
        if (path == null) {
            throw new NullPointerException("No null conf path");
        }
        this.log.info("Added " + path.getValue() + " command to conf path");
        this.confFS.mount(this.loader, path);
        return this;
    }

    public Bootstrap addToCmdPath(File path) throws NullPointerException, IOException {
        if (path == null) {
            throw new NullPointerException("No null command path");
        }
        this.log.info("Added " + path.getAbsolutePath() + " command to command path");
        this.cmdFS.mount(path);
        return this;
    }

    public Bootstrap addToCmdPath(Path path) throws NullPointerException, IOException, URISyntaxException {
        if (path == null) {
            throw new NullPointerException("No null command path");
        }
        this.log.info("Added " + path.getValue() + " command to command path");
        this.cmdFS.mount(this.loader, path);
        return this;
    }

    public void bootstrap() throws Exception {
        ServiceLoaderDiscovery discovery = new ServiceLoaderDiscovery(this.loader);
        PluginContext context = new PluginContext(discovery, this.attributes, this.cmdFS, this.confFS, this.loader);
        context.refresh();
        this.start(context);
    }

    public void shutdown() {
        this.stop();
    }
}

