/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.standalone;

import com.sun.tools.attach.VirtualMachine;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.List;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import jline.Terminal;
import jline.TerminalFactory;
import jline.console.ConsoleReader;
import org.crsh.cli.Argument;
import org.crsh.cli.Command;
import org.crsh.cli.Option;
import org.crsh.cli.Usage;
import org.crsh.cli.impl.Delimiter;
import org.crsh.cli.impl.descriptor.CommandDescriptorImpl;
import org.crsh.cli.impl.descriptor.IntrospectionException;
import org.crsh.cli.impl.invocation.InvocationMatch;
import org.crsh.cli.impl.invocation.InvocationMatcher;
import org.crsh.cli.impl.lang.CommandFactory;
import org.crsh.processor.jline.JLineProcessor;
import org.crsh.shell.Shell;
import org.crsh.shell.ShellFactory;
import org.crsh.shell.impl.remoting.RemoteServer;
import org.crsh.standalone.Agent;
import org.crsh.standalone.Bootstrap;
import org.crsh.standalone.ResourceMode;
import org.crsh.util.CloseableList;
import org.crsh.util.IO;
import org.crsh.util.InterruptHandler;
import org.crsh.util.Safe;
import org.crsh.vfs.FS;
import org.crsh.vfs.Path;
import org.crsh.vfs.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CRaSH {
    private static Logger log = Logger.getLogger(CRaSH.class.getName());
    private final CommandDescriptorImpl<CRaSH> descriptor = CommandFactory.DEFAULT.create(CRaSH.class);

    private void copy(org.crsh.vfs.File src, File dst) throws IOException {
        Resource resource;
        if (src.isDir()) {
            if (!dst.exists() && dst.mkdir()) {
                log.fine("Could not create dir " + dst.getCanonicalPath());
            }
            if (dst.exists() && dst.isDirectory()) {
                for (org.crsh.vfs.File child : src.children()) {
                    this.copy(child, new File(dst, child.getName()));
                }
            }
        } else if (!dst.exists() && (resource = src.getResource()) != null) {
            log.info("Copied resource " + src.getPath().getValue() + " to " + dst.getCanonicalPath());
            IO.copy(new ByteArrayInputStream(resource.getContent()), new FileOutputStream(dst));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command
    public void main(@Option(names={"c", "cmd"}) @Usage(value="adds a dir to the command path") List<String> cmds, @Option(names={"conf"}) @Usage(value="adds a dir to the conf path") List<String> confs, @Option(names={"p", "property"}) @Usage(value="set a property of the form a=b") List<String> properties, @Option(names={"cmd-mode"}) @Usage(value="the cmd mode (read or copy), copy mode requires at least one cmd path to be specified") ResourceMode cmdMode, @Option(names={"conf-mode"}) @Usage(value="the conf mode (read of copy), copy mode requires at least one conf path to be specified") ResourceMode confMode, @Argument(name="pid") @Usage(value="the optional JVM process id to attach to") Integer pid) throws Exception {
        Shell shell;
        org.crsh.vfs.File f;
        FS fs;
        File dst;
        boolean copyConf;
        boolean copyCmd = cmdMode != ResourceMode.read && cmds != null && cmds.size() > 0;
        boolean bl = copyConf = confMode != ResourceMode.read && confs != null && confs.size() > 0;
        if (copyCmd) {
            dst = new File(cmds.get(0));
            if (!dst.isDirectory()) {
                throw new Exception("Directory " + dst.getAbsolutePath() + " does not exist");
            }
            fs = new FS();
            fs.mount(Thread.currentThread().getContextClassLoader(), Path.get("/crash/commands/"));
            f = fs.get(Path.get("/"));
            log.info("Copying command classpath resources");
            this.copy(f, dst);
        }
        if (copyConf) {
            dst = new File(confs.get(0));
            if (!dst.isDirectory()) {
                throw new Exception("Directory " + dst.getAbsolutePath() + " does not exist");
            }
            fs = new FS();
            fs.mount(Thread.currentThread().getContextClassLoader(), Path.get("/crash/"));
            f = fs.get(Path.get("/"));
            log.info("Copying conf classpath resources");
            for (org.crsh.vfs.File child : f.children()) {
                if (child.isDir()) continue;
                this.copy(child, new File(dst, child.getName()));
            }
        }
        CloseableList closeable = new CloseableList();
        if (pid != null) {
            log.log(Level.INFO, "Attaching to remote process " + pid);
            final VirtualMachine vm = VirtualMachine.attach("" + pid);
            String classpath = System.getProperty("java.class.path");
            String sep = System.getProperty("path.separator");
            StringBuilder buffer = new StringBuilder();
            for (String path : classpath.split(Pattern.quote(sep))) {
                File file = new File(path);
                if (!file.exists()) continue;
                if (buffer.length() > 0) {
                    buffer.append(' ');
                }
                buffer.append(file.getCanonicalPath());
            }
            Manifest manifest = new Manifest();
            Attributes attributes = manifest.getMainAttributes();
            attributes.putValue("Agent-Class", Agent.class.getName());
            attributes.put(Attributes.Name.MANIFEST_VERSION, "1.0");
            attributes.put(Attributes.Name.CLASS_PATH, buffer.toString());
            File agentFile = File.createTempFile("agent", ".jar");
            agentFile.deleteOnExit();
            JarOutputStream out = new JarOutputStream((OutputStream)new FileOutputStream(agentFile), manifest);
            out.close();
            log.log(Level.INFO, "Created agent jar " + agentFile.getCanonicalPath());
            RemoteServer server = new RemoteServer(0);
            int port = server.bind();
            log.log(Level.INFO, "Callback server set on port " + port);
            StringBuilder sb = new StringBuilder();
            if (copyCmd) {
                sb.append("--cmd-mode copy ");
            } else {
                sb.append("--cmd-mode read ");
            }
            if (cmds != null) {
                for (String cmd : cmds) {
                    File cmdPath = new File(cmd);
                    if (!cmdPath.exists()) continue;
                    sb.append("--cmd ");
                    Delimiter.EMPTY.escape(cmdPath.getCanonicalPath(), sb);
                    sb.append(' ');
                }
            }
            if (copyCmd) {
                sb.append("--conf-mode copy ");
            } else {
                sb.append("--conf-mode read ");
            }
            if (confs != null) {
                for (String conf : confs) {
                    File confPath = new File(conf);
                    if (!confPath.exists()) continue;
                    sb.append("--conf ");
                    Delimiter.EMPTY.escape(confPath.getCanonicalPath(), sb);
                    sb.append(' ');
                }
            }
            if (properties != null) {
                for (String property : properties) {
                    sb.append("--property ");
                    Delimiter.EMPTY.escape(property, sb);
                    sb.append(' ');
                }
            }
            sb.append(port);
            String options = sb.toString();
            log.log(Level.INFO, "Loading agent with command " + options + " as agent " + agentFile.getCanonicalPath());
            vm.loadAgent(agentFile.getCanonicalPath(), options);
            server.accept();
            shell = server.getShell();
            closeable.add(new Closeable(){

                public void close() throws IOException {
                    vm.detach();
                }
            });
        } else {
            final Bootstrap bootstrap = new Bootstrap(Thread.currentThread().getContextClassLoader());
            if (!copyCmd) {
                bootstrap.addToCmdPath(Path.get("/crash/commands/"));
            }
            if (cmds != null) {
                for (String cmd : cmds) {
                    File cmdPath = new File(cmd);
                    bootstrap.addToCmdPath(cmdPath);
                }
            }
            if (!copyConf) {
                bootstrap.addToConfPath(Path.get("/crash/"));
            }
            if (confs != null) {
                for (String conf : confs) {
                    File confPath = new File(conf);
                    bootstrap.addToConfPath(confPath);
                }
            }
            if (properties != null) {
                Properties config = new Properties();
                for (String property : properties) {
                    int index = property.indexOf(61);
                    if (index == -1) {
                        config.setProperty(property, "");
                        continue;
                    }
                    config.setProperty(property.substring(0, index), property.substring(index + 1));
                }
                bootstrap.setConfig(config);
            }
            Runtime.getRuntime().addShutdownHook(new Thread(){

                public void run() {
                }
            });
            bootstrap.bootstrap();
            Runtime.getRuntime().addShutdownHook(new Thread(){

                public void run() {
                    bootstrap.shutdown();
                }
            });
            ShellFactory factory = bootstrap.getContext().getPlugin(ShellFactory.class);
            shell = factory.create(null);
            closeable = null;
        }
        final Terminal term = TerminalFactory.create();
        term.init();
        ConsoleReader reader = new ConsoleReader(null, new FileInputStream(FileDescriptor.in), System.out, term);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                try {
                    term.restore();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        PrintWriter out = new PrintWriter(System.out);
        final JLineProcessor processor = new JLineProcessor(shell, reader, out);
        reader.addCompleter(processor);
        InterruptHandler ih = new InterruptHandler(new Runnable(){

            public void run() {
                processor.cancel();
            }
        });
        ih.install();
        try {
            processor.run();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        finally {
            if (closeable != null) {
                Safe.close(closeable);
            }
            System.exit(0);
        }
    }

    public static void main(String[] args) throws Exception {
        StringBuilder line = new StringBuilder();
        for (int i = 0; i < args.length; ++i) {
            if (i > 0) {
                line.append(' ');
            }
            Delimiter.EMPTY.escape(args[i], line);
        }
        CRaSH main = new CRaSH();
        InvocationMatcher<CRaSH> matcher = main.descriptor.invoker("main");
        InvocationMatch<CRaSH> match = matcher.match(line.toString());
        match.invoke(new CRaSH());
    }
}

