/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.term.spi;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;
import org.crsh.term.CodeType;
import org.crsh.term.spi.TermIO;
import org.crsh.text.Style;

public class TestTermIO
implements TermIO {
    private static final int TAB = -1;
    private static final int DEL = -2;
    private static final int UP = -3;
    private static final int DOWN = -4;
    private static final int RIGHT = -5;
    private static final int LEFT = -6;
    private static final int BREAK = -7;
    private static final int BACKWARD_WORD = -8;
    private static final int FORWARD_WORD = -9;
    private static final int BEGINNING_OF_LINE = -10;
    private static final int END_OF_LINE = -11;
    private final BlockingQueue<Integer> inner = new LinkedBlockingQueue<Integer>();
    private final BlockingQueue<String> outter = new LinkedBlockingQueue<String>();
    private int width = 32;
    private int height = 40;
    private Map<String, String> properties = new HashMap<String, String>();

    public int read() throws IOException {
        try {
            return this.inner.take();
        }
        catch (InterruptedException e) {
            AssertionFailedError afe = new AssertionFailedError();
            afe.initCause((Throwable)e);
            throw afe;
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setProperty(String name, String value) {
        if (value != null) {
            this.properties.put(name, value);
        } else {
            this.properties.remove(name);
        }
    }

    public String getProperty(String name) {
        return this.properties.get(name);
    }

    public boolean takeAlternateBuffer() {
        return false;
    }

    public boolean releaseAlternateBuffer() {
        return false;
    }

    public void setWidth(int width) {
        if (width < 1) {
            throw new IllegalArgumentException("No negative width accepted");
        }
        this.width = width;
    }

    public TestTermIO appendTab() {
        return this.append(-1);
    }

    public TestTermIO appendDel() {
        return this.append(-2);
    }

    public TestTermIO appendMoveUp() {
        return this.append(-3);
    }

    public TestTermIO appendMoveDown() {
        return this.append(-4);
    }

    public TestTermIO appendMoveRight() {
        return this.append(-5);
    }

    public TestTermIO appendMoveLeft() {
        return this.append(-6);
    }

    public TestTermIO appendBreak() {
        return this.append(-7);
    }

    public TestTermIO appendBackwardWord() {
        return this.append(-8);
    }

    public TestTermIO appendForwardWord() {
        return this.append(-9);
    }

    public TestTermIO appendBeginningOfLine() {
        return this.append(-10);
    }

    public TestTermIO appendEndOfLine() {
        return this.append(-11);
    }

    public TestTermIO append(char c) {
        return this.append((int)c);
    }

    public TestTermIO append(CharSequence s) {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            this.append(c);
        }
        return this;
    }

    private TestTermIO append(int c) {
        this.inner.add(c);
        return this;
    }

    public CodeType decode(int code) {
        switch (code) {
            case -7: {
                return CodeType.BREAK;
            }
            case -2: {
                return CodeType.BACKSPACE;
            }
            case -1: {
                return CodeType.TAB;
            }
            case -3: {
                return CodeType.UP;
            }
            case -4: {
                return CodeType.DOWN;
            }
            case -6: {
                return CodeType.LEFT;
            }
            case -5: {
                return CodeType.RIGHT;
            }
            case -8: {
                return CodeType.BACKWARD_WORD;
            }
            case -9: {
                return CodeType.FORWARD_WORD;
            }
            case -10: {
                return CodeType.BEGINNING_OF_LINE;
            }
            case -11: {
                return CodeType.END_OF_LINE;
            }
        }
        return CodeType.CHAR;
    }

    public TestTermIO assertChar(char c) {
        return this.assertRead(String.valueOf(c));
    }

    public TestTermIO assertChars(String s) {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            this.assertChar(c);
        }
        return this;
    }

    public TestTermIO assertDel() {
        return this.assertRead("del");
    }

    public TestTermIO assertMoveLeft() {
        return this.assertRead("left");
    }

    public TestTermIO assertMoveRight() {
        return this.assertRead("right");
    }

    public TestTermIO assertCRLF() {
        return this.assertRead("crlf");
    }

    public TestTermIO assertCLS() {
        return this.assertRead("cls");
    }

    public TestTermIO assertFlush() {
        return this.assertRead("flush");
    }

    private TestTermIO assertRead(String expected) {
        if (expected.length() == 0) {
            Assert.fail();
        }
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            for (int i = 0; i < expected.length(); ++i) {
                char c = expected.charAt(i);
                sb.append(c);
            }
            sb.append("]");
            String s = this.outter.take();
            Assert.assertEquals((String)sb.toString(), (String)s);
        }
        catch (InterruptedException e) {
            AssertionFailedError afe = new AssertionFailedError();
            afe.initCause((Throwable)e);
            throw afe;
        }
        return this;
    }

    public TestTermIO assertEmpty() {
        Assert.assertEquals(Collections.emptyList(), new ArrayList<String>(this.outter));
        return this;
    }

    public void write(CharSequence s) throws IOException {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            this.write(c);
        }
    }

    public void write(char c) throws IOException {
        this.outter.add("[" + c + "]");
    }

    public void flush() throws IOException {
        this.outter.add("[flush]");
    }

    public void close() {
        throw new UnsupportedOperationException();
    }

    public void write(Style d) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void cls() throws IOException {
        this.outter.add("[cls]");
    }

    public void writeDel() throws IOException {
        this.outter.add("[del]");
    }

    public void writeCRLF() throws IOException {
        this.outter.add("[crlf]");
    }

    public boolean moveRight(char c) throws IOException {
        this.outter.add("[right]");
        return true;
    }

    public boolean moveLeft() throws IOException {
        this.outter.add("[left]");
        return true;
    }
}

