/*
 * Decompiled with CFR 0.152.
 */
package org.crsh;

import junit.framework.AssertionFailedError;
import junit.framework.TestCase;

public abstract class AbstractTestCase
extends TestCase {
    protected AbstractTestCase() {
    }

    protected AbstractTestCase(String name) {
        super(name);
    }

    public static AssertionFailedError failure(Throwable t) {
        AssertionFailedError afe = new AssertionFailedError();
        afe.initCause(t);
        return afe;
    }

    public static AssertionFailedError failure(Object message) {
        return new AssertionFailedError("" + message);
    }

    public static void safeFail(Throwable throwable) {
        if (throwable != null) {
            AssertionFailedError afe = new AssertionFailedError();
            afe.initCause(throwable);
            throw afe;
        }
    }

    public static <T> T assertInstance(Class<T> expectedType, Object o) {
        if (expectedType.isInstance(o)) {
            return expectedType.cast(o);
        }
        throw AbstractTestCase.failure("Was expecting the object " + o + " to be an instance of " + expectedType.getName());
    }

    public static <T> T assertType(Class<T> expectedType, Object o) {
        if (o == null) {
            throw AbstractTestCase.failure("Was expecting the object " + o + " to not be null");
        }
        if (o.getClass().equals(expectedType)) {
            return expectedType.cast(o);
        }
        throw AbstractTestCase.failure("Was expecting the object " + o + " to be an instance of " + expectedType.getName());
    }

    public static void assertJoin(Thread thread) {
        AbstractTestCase.assertJoin(thread, 5000L);
    }

    public static void assertJoin(Thread thread, long timeMillis) {
        long before = System.currentTimeMillis();
        try {
            thread.join(timeMillis);
        }
        catch (InterruptedException e) {
            throw AbstractTestCase.failure(e);
        }
        long after = System.currentTimeMillis();
        if (after - before >= timeMillis) {
            throw AbstractTestCase.failure("Join failed");
        }
    }
}

