/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.shell.impl.async;

import java.io.IOException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.crsh.AbstractTestCase;
import org.crsh.BaseProcess;
import org.crsh.BaseProcessContext;
import org.crsh.BaseProcessFactory;
import org.crsh.BaseShell;
import org.crsh.TestPluginLifeCycle;
import org.crsh.shell.Shell;
import org.crsh.shell.ShellProcessContext;
import org.crsh.shell.ShellResponse;
import org.crsh.shell.impl.async.AsyncProcess;
import org.crsh.shell.impl.async.AsyncShell;
import org.crsh.shell.impl.async.Status;
import org.crsh.text.Text;

public class AsyncShellTestCase
extends AbstractTestCase {
    protected TestPluginLifeCycle lifeCycle;
    private static volatile int status;

    protected void setUp() throws Exception {
        super.setUp();
        TestPluginLifeCycle lifeCycle = new TestPluginLifeCycle();
        lifeCycle.start();
        this.lifeCycle = lifeCycle;
    }

    public void testReadLine() throws Exception {
        BaseProcessFactory factory = new BaseProcessFactory(){

            @Override
            public BaseProcess create(String request) {
                return new BaseProcess(request){

                    @Override
                    public void process(String request, ShellProcessContext processContext) throws IOException {
                        String a = this.readLine("bar", true);
                        processContext.provide((Object)Text.create((CharSequence)a));
                        processContext.end((ShellResponse)ShellResponse.ok());
                    }
                };
            }
        };
        BaseShell shell = new BaseShell(factory);
        AsyncShell asyncShell = new AsyncShell((Executor)Executors.newSingleThreadExecutor(), (Shell)shell);
        BaseProcessContext ctx = BaseProcessContext.create((Shell)asyncShell, "foo");
        ctx.addLineInput("juu");
        ctx.execute();
        ShellResponse resp = ctx.getResponse();
        AsyncShellTestCase.assertInstance(ShellResponse.Ok.class, resp);
        AsyncShellTestCase.assertEquals((String)"barjuu", (String)ctx.getOutput());
        ctx.assertNoInput();
    }

    public void testAsyncEvaluation() throws InterruptedException {
        AsyncShell connector = new AsyncShell((Executor)Executors.newSingleThreadExecutor(), (Shell)this.lifeCycle.createShell());
        status = 0;
        BaseProcessContext ctx = BaseProcessContext.create((Shell)connector, "invoke " + AsyncShellTestCase.class.getName() + " bilto");
        ctx.execute();
        ShellResponse resp = ctx.getResponse();
        AsyncShellTestCase.assertTrue((String)("Was not expecting response to be " + resp.getMessage()), (boolean)(resp instanceof ShellResponse.Ok));
        AsyncShellTestCase.assertEquals((int)1, (int)status);
        ctx.getResponse();
    }

    public static void bilto() {
        status = status == 0 ? 1 : -1;
    }

    public void testDirect() throws Exception {
        BaseShell shell = new BaseShell(BaseProcessFactory.ECHO);
        AsyncShell asyncShell = new AsyncShell(new Executor(){

            @Override
            public void execute(Runnable command) {
                command.run();
            }
        }, (Shell)shell);
        BaseProcessContext ctx = BaseProcessContext.create((Shell)asyncShell, "hello").execute();
        AsyncShellTestCase.assertEquals((Object)Status.TERMINATED, (Object)((AsyncProcess)ctx.getProcess()).getStatus());
        AsyncShellTestCase.assertInstance(ShellResponse.Ok.class, ctx.getResponse());
        AsyncShellTestCase.assertEquals((String)"hello", (String)ctx.getOutput());
    }
}

