/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.processor.term;

import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import org.crsh.BaseProcess;
import org.crsh.BaseProcessFactory;
import org.crsh.BaseShell;
import org.crsh.cli.impl.Delimiter;
import org.crsh.cli.impl.completion.CompletionMatch;
import org.crsh.cli.spi.Completion;
import org.crsh.processor.term.Processor;
import org.crsh.shell.Shell;
import org.crsh.shell.ShellProcess;
import org.crsh.shell.ShellProcessContext;
import org.crsh.shell.ShellResponse;
import org.crsh.term.Term;
import org.crsh.term.console.ConsoleTerm;
import org.crsh.term.spi.TermIO;
import org.crsh.term.spi.TestTermIO;
import org.crsh.text.CLS;

public class ProcessorTestCase
extends TestCase {
    public void testLine() throws Exception {
        Controller controller = this.create(new BaseShell(BaseProcessFactory.ECHO));
        controller.assertStart();
        controller.connector.append("abc\r\n");
        controller.connector.assertChars("a").assertFlush();
        controller.connector.assertChars("b").assertFlush();
        controller.connector.assertChars("c").assertFlush();
        controller.connector.assertCRLF().assertFlush();
        controller.connector.assertChars("abc").assertFlush();
        controller.connector.assertCRLF().assertChars("% ").assertFlush();
        controller.assertStop();
    }

    public void testDel() throws Exception {
        Controller controller = this.create(new BaseShell(BaseProcessFactory.ECHO));
        controller.assertStart();
        controller.connector.append("abc");
        controller.connector.appendDel();
        controller.connector.append("\r\n");
        controller.connector.assertChars("a").assertFlush();
        controller.connector.assertChars("b").assertFlush();
        controller.connector.assertChars("c").assertFlush();
        controller.connector.assertDel().assertFlush();
        controller.connector.assertCRLF().assertFlush();
        controller.connector.assertChars("ab").assertFlush();
        controller.connector.assertCRLF().assertChars("% ").assertFlush();
        controller.assertStop();
    }

    public void testBreak() throws Exception {
        Controller controller = this.create(new BaseShell(BaseProcessFactory.ECHO));
        controller.assertStart();
        controller.connector.append("abc");
        controller.connector.appendBreak();
        controller.connector.assertChars("a").assertFlush();
        controller.connector.assertChars("b").assertFlush();
        controller.connector.assertChars("c").assertFlush();
        controller.connector.assertCRLF().assertChars("% ").assertFlush();
        controller.connector.append("def\r\n");
        controller.connector.assertChars("d").assertFlush();
        controller.connector.assertChars("e").assertFlush();
        controller.connector.assertChars("f").assertFlush();
        controller.connector.assertCRLF().assertFlush();
        controller.connector.assertChars("def").assertFlush();
        controller.connector.assertCRLF().assertChars("% ").assertFlush();
        controller.assertStop();
    }

    public void testInsert() throws Exception {
        Controller controller = this.create(new BaseShell(BaseProcessFactory.ECHO));
        controller.assertStart();
        controller.connector.append("ab");
        controller.connector.appendMoveLeft();
        controller.connector.append("c\r\n");
        controller.connector.assertChars("a").assertFlush();
        controller.connector.assertChars("b").assertFlush();
        controller.connector.assertMoveLeft().assertFlush();
        controller.connector.assertChars("cb").assertMoveLeft().assertFlush();
        controller.connector.assertCRLF().assertFlush();
        controller.connector.assertChars("acb").assertFlush();
        controller.connector.assertCRLF().assertChars("% ").assertFlush();
        controller.assertStop();
    }

    public void testIdempotentMoveRight() throws Exception {
        Controller controller = this.create(new BaseShell(BaseProcessFactory.ECHO));
        controller.assertStart();
        controller.connector.append("a");
        controller.connector.appendMoveRight();
        controller.connector.append("\r\n");
        controller.connector.assertChars("a").assertFlush();
        controller.connector.assertCRLF().assertFlush();
        controller.connector.assertChars("a").assertFlush();
        controller.connector.assertCRLF().assertChars("% ").assertFlush();
        controller.assertStop();
    }

    public void testIdempotentMoveLeft() throws Exception {
        Controller controller = this.create(new BaseShell(BaseProcessFactory.ECHO));
        controller.assertStart();
        controller.connector.appendMoveLeft();
        controller.connector.append("a");
        controller.connector.append("\r\n");
        controller.connector.assertChars("a").assertFlush();
        controller.connector.assertCRLF().assertFlush();
        controller.connector.assertChars("a").assertFlush();
        controller.connector.assertCRLF().assertChars("% ").assertFlush();
        controller.assertStop();
    }

    public void testMove() throws Exception {
        Controller controller = this.create(new BaseShell(BaseProcessFactory.ECHO));
        controller.assertStart();
        controller.connector.append("a");
        controller.connector.append("\r\n");
        controller.connector.assertChars("a").assertFlush();
        controller.connector.assertCRLF().assertFlush();
        controller.connector.assertChars("a").assertFlush();
        controller.connector.assertCRLF().assertChars("% ").assertFlush();
        controller.connector.appendMoveUp();
        controller.connector.assertChars("a").assertFlush();
        controller.connector.append("\r\n");
        controller.connector.assertCRLF().assertFlush();
        controller.connector.assertChars("a").assertFlush();
        controller.connector.assertCRLF().assertChars("% ").assertFlush();
        controller.connector.appendMoveUp();
        controller.connector.assertChars("a").assertFlush();
        controller.connector.appendMoveDown();
        controller.connector.assertDel().assertFlush();
        controller.assertStop();
    }

    public void testIdempotentMoveUp() throws Exception {
        Controller controller = this.create(new BaseShell(BaseProcessFactory.ECHO));
        controller.assertStart();
        controller.connector.append("a");
        controller.connector.append("\r\n");
        controller.connector.assertChars("a").assertFlush();
        controller.connector.assertCRLF().assertFlush();
        controller.connector.assertChars("a").assertFlush();
        controller.connector.assertCRLF().assertChars("% ").assertFlush();
        controller.connector.appendMoveUp();
        controller.connector.appendMoveUp();
        controller.connector.assertChars("a").assertFlush();
        controller.connector.append("\r\n");
        controller.connector.assertCRLF().assertFlush();
        controller.connector.assertChars("a").assertFlush();
        controller.connector.assertCRLF().assertChars("% ").assertFlush();
        controller.assertStop();
    }

    public void testIdempotentMoveDown() throws Exception {
        Controller controller = this.create(new BaseShell(BaseProcessFactory.ECHO));
        controller.assertStart();
        controller.connector.append("a");
        controller.connector.append("\r\n");
        controller.connector.assertChars("a").assertFlush();
        controller.connector.assertCRLF().assertFlush();
        controller.connector.assertChars("a").assertFlush();
        controller.connector.assertCRLF().assertChars("% ").assertFlush();
        controller.connector.appendMoveDown();
        controller.connector.append("\r\n");
        controller.connector.assertCRLF().assertFlush();
        controller.connector.assertFlush();
        controller.connector.assertCRLF().assertChars("% ").assertFlush();
        controller.assertStop();
    }

    public void testCompletion1() throws Exception {
        Controller controller = this.create(new BaseShell(BaseProcessFactory.ECHO){

            @Override
            public CompletionMatch complete(String prefix) {
                return new CompletionMatch(Delimiter.EMPTY, Completion.create((String)new StringBuilder(prefix).reverse().toString(), (boolean)false));
            }
        });
        controller.assertStart();
        controller.connector.append("ab");
        controller.connector.appendTab();
        controller.connector.assertChars("a").assertFlush();
        controller.connector.assertChars("b").assertFlush();
        controller.connector.assertChars("ba").assertFlush();
    }

    public void testMultiLine() throws Exception {
        final LinkedList requests = new LinkedList();
        final CountDownLatch latch = new CountDownLatch(1);
        Controller controller = this.create(new BaseShell(BaseProcessFactory.ECHO){

            @Override
            public ShellProcess createProcess(String request) {
                return new BaseProcess(request){

                    @Override
                    protected ShellResponse execute(String request) {
                        requests.add(request);
                        latch.countDown();
                        return super.execute(request);
                    }
                };
            }
        });
        controller.assertStart();
        controller.connector.append("a\\\r\n");
        controller.connector.assertChars("a").assertFlush();
        controller.connector.assertChars("\\").assertFlush();
        controller.connector.assertCRLF().assertFlush().assertChars("> ").assertFlush();
        ProcessorTestCase.assertEquals(Collections.emptyList(), requests);
        controller.connector.append("b\r\n");
        controller.connector.assertChars("b").assertFlush();
        controller.connector.assertCRLF().assertFlush();
        latch.await(5L, TimeUnit.SECONDS);
        ProcessorTestCase.assertEquals(Collections.singletonList("ab"), requests);
    }

    public void testCLS() throws Exception {
        Controller controller = this.create(new BaseShell(new BaseProcessFactory(){

            @Override
            public BaseProcess create(String request) {
                return new BaseProcess(request){

                    @Override
                    public void process(String request, ShellProcessContext processContext) throws IOException {
                        if ("bye".equals(request)) {
                            processContext.end((ShellResponse)ShellResponse.close());
                        } else {
                            processContext.provide((Object)CLS.INSTANCE);
                            processContext.end((ShellResponse)ShellResponse.ok());
                        }
                    }
                };
            }
        }));
        controller.assertStart();
        controller.connector.append("\r\n");
        controller.connector.assertCRLF().assertFlush();
        controller.connector.assertCLS().assertFlush();
        controller.connector.assertCRLF().assertChars("% ").assertFlush();
        controller.assertStop();
    }

    public void testFlush() throws Exception {
        Controller controller = this.create(new BaseShell(new BaseProcessFactory(){

            @Override
            public BaseProcess create(String request) {
                return new BaseProcess(request){

                    @Override
                    public void process(String request, ShellProcessContext processContext) throws IOException {
                        if ("bye".equals(request)) {
                            processContext.end((ShellResponse)ShellResponse.close());
                        } else {
                            processContext.flush();
                            processContext.end((ShellResponse)ShellResponse.ok());
                        }
                    }
                };
            }
        }));
        controller.assertStart();
        controller.connector.append("\r\n");
        controller.connector.assertCRLF().assertFlush();
        controller.connector.assertFlush();
        controller.connector.assertFlush();
        controller.connector.assertCRLF().assertChars("% ").assertFlush();
        controller.assertStop();
    }

    private Controller create(Shell shell) throws IOException {
        return new Controller(new TestTermIO(), shell);
    }

    private class Controller
    implements Runnable {
        private volatile boolean running = true;
        private final CountDownLatch startSync = new CountDownLatch(1);
        private final CountDownLatch stopSync = new CountDownLatch(1);
        private final Thread thread = new Thread(this);
        private final TestTermIO connector;
        private final Processor processor;

        private Controller(TestTermIO connector, Shell shell) {
            this.connector = connector;
            this.processor = new Processor((Term)new ConsoleTerm((TermIO)connector), shell);
        }

        public void assertStart() {
            this.thread.start();
            try {
                Assert.assertTrue((boolean)this.startSync.await(1L, TimeUnit.SECONDS));
            }
            catch (InterruptedException e) {
                AssertionFailedError afe = new AssertionFailedError();
                afe.initCause((Throwable)e);
                throw afe;
            }
            Assert.assertTrue((boolean)this.running);
            this.connector.assertCRLF();
            this.connector.assertChars("% ");
            this.connector.assertFlush();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.running = true;
            this.startSync.countDown();
            try {
                this.processor.run();
            }
            finally {
                this.running = false;
                this.stopSync.countDown();
            }
        }

        public void assertStop() {
            Assert.assertTrue((boolean)this.running);
            this.connector.append("bye\r\n");
            this.connector.assertChars("b").assertFlush();
            this.connector.assertChars("y").assertFlush();
            this.connector.assertChars("e").assertFlush();
            this.connector.assertCRLF().assertFlush();
            try {
                Assert.assertTrue((boolean)this.stopSync.await(4L, TimeUnit.SECONDS));
            }
            catch (InterruptedException e) {
                AssertionFailedError afe = new AssertionFailedError();
                afe.initCause((Throwable)e);
                throw afe;
            }
            this.connector.assertEmpty();
            Assert.assertFalse((boolean)this.running);
        }
    }
}

