/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.term.console;

import java.io.IOException;
import junit.framework.TestCase;
import org.crsh.term.console.SimpleTermIO;
import org.crsh.term.console.TermIOBuffer;
import org.crsh.term.spi.TermIO;

public abstract class AbstractTermBufferTestCase
extends TestCase {
    private SimpleTermIO client;
    private TermIOBuffer buffer;

    protected abstract boolean getSupportsCursorMove();

    private static void assertEquals(CharSequence expected, CharSequence actual) {
        AbstractTermBufferTestCase.assertEquals((String)expected.toString(), (String)actual.toString());
    }

    protected void setUp() throws Exception {
        this.resetConsole();
    }

    private void resetConsole() {
        this.client = new SimpleTermIO(this.getSupportsCursorMove());
        this.buffer = new TermIOBuffer((TermIO)this.client);
    }

    public void testNoCR() throws IOException {
        this.buffer.append((CharSequence)"a");
        AbstractTermBufferTestCase.assertFalse((boolean)this.buffer.hasNext());
        AbstractTermBufferTestCase.assertEquals((int)1, (int)this.buffer.getSize());
    }

    public void testReadLine() throws IOException {
        for (String test : new String[]{"a\n", "a\r", "a\r\n"}) {
            this.resetConsole();
            this.buffer.append((CharSequence)test);
            AbstractTermBufferTestCase.assertTrue((boolean)this.buffer.hasNext());
            AbstractTermBufferTestCase.assertEquals("a", this.buffer.next());
            AbstractTermBufferTestCase.assertFalse((boolean)this.buffer.hasNext());
            AbstractTermBufferTestCase.assertEquals((int)0, (int)this.buffer.getSize());
        }
        for (String test : new String[]{"a\n\n", "a\n\r", "a\r\r"}) {
            this.resetConsole();
            this.buffer.append((CharSequence)test);
            AbstractTermBufferTestCase.assertTrue((boolean)this.buffer.hasNext());
            AbstractTermBufferTestCase.assertEquals("a", this.buffer.next());
            AbstractTermBufferTestCase.assertEquals("", this.buffer.next());
            AbstractTermBufferTestCase.assertFalse((boolean)this.buffer.hasNext());
            AbstractTermBufferTestCase.assertEquals((int)0, (int)this.buffer.getSize());
        }
    }

    public void testErase() throws IOException {
        this.resetConsole();
        this.buffer.append((CharSequence)"a");
        this.buffer.del();
        this.buffer.append((CharSequence)"b\n");
        AbstractTermBufferTestCase.assertTrue((boolean)this.buffer.hasNext());
        AbstractTermBufferTestCase.assertEquals("b", this.buffer.next());
        AbstractTermBufferTestCase.assertFalse((boolean)this.buffer.hasNext());
    }

    public void testMoveLeftInsert() throws IOException {
        this.resetConsole();
        this.buffer.append((CharSequence)"a");
        this.buffer.moveLeft();
        this.buffer.append((CharSequence)"b\n");
        AbstractTermBufferTestCase.assertTrue((boolean)this.buffer.hasNext());
        AbstractTermBufferTestCase.assertEquals(this.getExpectedMoveLeftInsert(), this.buffer.next());
        AbstractTermBufferTestCase.assertFalse((boolean)this.buffer.hasNext());
    }

    protected abstract String getExpectedMoveLeftInsert();

    public void testMoveLeftDel() throws IOException {
        this.resetConsole();
        this.buffer.append((CharSequence)"ab");
        int expected = this.buffer.moveLeft() ? 97 : 98;
        AbstractTermBufferTestCase.assertEquals((int)expected, (int)this.buffer.del());
        if (this.getSupportsCursorMove()) {
            this.client.assertChars("b ");
            this.client.assertEmpty();
        } else {
            this.client.assertChars("a");
            this.client.assertEmpty();
        }
        this.buffer.append((CharSequence)"\n");
        AbstractTermBufferTestCase.assertTrue((boolean)this.buffer.hasNext());
        AbstractTermBufferTestCase.assertEquals(this.getExpectedMoveLeftDel(), this.buffer.next());
        AbstractTermBufferTestCase.assertFalse((boolean)this.buffer.hasNext());
    }

    protected abstract String getExpectedMoveLeftDel();

    public void testMoveRightInsert() throws IOException {
        this.resetConsole();
        this.buffer.append((CharSequence)"abc");
        this.buffer.moveLeft();
        this.buffer.moveLeft();
        this.buffer.moveRight();
        this.buffer.append((CharSequence)"d\n");
        AbstractTermBufferTestCase.assertTrue((boolean)this.buffer.hasNext());
        AbstractTermBufferTestCase.assertEquals(this.getExpectedMoveRightInsert(), this.buffer.next());
        AbstractTermBufferTestCase.assertFalse((boolean)this.buffer.hasNext());
    }

    protected abstract String getExpectedMoveRightInsert();

    public void testMoveRightDel() throws IOException {
        this.resetConsole();
        this.buffer.append((CharSequence)"abc");
        this.buffer.moveLeft();
        this.buffer.moveLeft();
        this.buffer.moveRight();
        this.buffer.del();
        this.buffer.append((CharSequence)"\n");
        AbstractTermBufferTestCase.assertTrue((boolean)this.buffer.hasNext());
        AbstractTermBufferTestCase.assertEquals(this.getExpectedMoveRightDel(), this.buffer.next());
        AbstractTermBufferTestCase.assertFalse((boolean)this.buffer.hasNext());
    }

    protected abstract String getExpectedMoveRightDel();

    public void testMoveRightAtEndOfLine() throws IOException {
        this.resetConsole();
        this.buffer.append((CharSequence)"a");
        this.buffer.moveRight();
        this.buffer.append((CharSequence)"b\n");
        AbstractTermBufferTestCase.assertTrue((boolean)this.buffer.hasNext());
        AbstractTermBufferTestCase.assertEquals(this.getExpectedMoveRightAtEndOfLine(), this.buffer.next());
        AbstractTermBufferTestCase.assertFalse((boolean)this.buffer.hasNext());
    }

    protected abstract String getExpectedMoveRightAtEndOfLine();

    public void testMoveRightByTwoChars() throws Exception {
        this.resetConsole();
        this.buffer.append((CharSequence)"ab");
        this.buffer.moveLeft();
        this.buffer.moveLeft();
        this.buffer.moveRight(2);
        this.buffer.append((CharSequence)"c\n");
        AbstractTermBufferTestCase.assertTrue((boolean)this.buffer.hasNext());
        AbstractTermBufferTestCase.assertEquals("abc", this.buffer.next());
        AbstractTermBufferTestCase.assertFalse((boolean)this.buffer.hasNext());
        this.client.assertChars("abc");
    }

    public void testMoveLeftAtBeginningOfLine() throws IOException {
        this.resetConsole();
        this.buffer.append((CharSequence)"a");
        this.buffer.moveLeft();
        this.buffer.moveLeft();
        this.buffer.append((CharSequence)"b\n");
        AbstractTermBufferTestCase.assertTrue((boolean)this.buffer.hasNext());
        AbstractTermBufferTestCase.assertEquals(this.getExpectedMoveLeftAtBeginningOfLine(), this.buffer.next());
        AbstractTermBufferTestCase.assertFalse((boolean)this.buffer.hasNext());
    }

    protected abstract String getExpectedMoveLeftAtBeginningOfLine();

    public void testClearBuffer() throws Exception {
        this.resetConsole();
        this.buffer.append((CharSequence)"a");
        this.buffer.clear();
        AbstractTermBufferTestCase.assertFalse((boolean)this.buffer.hasNext());
        this.buffer.append((CharSequence)"b\n");
        AbstractTermBufferTestCase.assertEquals("b", this.buffer.next());
        AbstractTermBufferTestCase.assertFalse((boolean)this.buffer.hasNext());
    }
}

