/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.shell.impl.command;

import groovy.lang.Binding;
import groovy.lang.Closure;
import groovy.lang.GroovyShell;
import java.io.Closeable;
import java.security.Principal;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.crsh.cli.impl.Delimiter;
import org.crsh.cli.impl.completion.CompletionMatch;
import org.crsh.cli.spi.Completion;
import org.crsh.command.BaseRuntimeContext;
import org.crsh.command.CommandInvoker;
import org.crsh.command.GroovyScript;
import org.crsh.command.GroovyScriptCommand;
import org.crsh.command.NoSuchCommandException;
import org.crsh.command.RuntimeContext;
import org.crsh.command.ScriptException;
import org.crsh.command.ShellCommand;
import org.crsh.plugin.ResourceKind;
import org.crsh.shell.ErrorType;
import org.crsh.shell.Shell;
import org.crsh.shell.ShellProcess;
import org.crsh.shell.ShellProcessContext;
import org.crsh.shell.ShellResponse;
import org.crsh.shell.impl.command.CRaSH;
import org.crsh.shell.impl.command.CRaSHProcess;
import org.crsh.shell.impl.command.CRaSHProcessContext;
import org.crsh.shell.impl.command.PipeLineFactory;
import org.crsh.shell.impl.command.PipeLineParser;
import org.crsh.text.Chunk;
import org.crsh.util.Safe;
import org.crsh.util.Utils;

public class CRaSHSession
extends HashMap<String, Object>
implements Shell,
Closeable,
RuntimeContext {
    static final Logger log = Logger.getLogger(CRaSHSession.class.getName());
    static final Logger accessLog = Logger.getLogger("org.crsh.shell.access");
    private GroovyShell groovyShell;
    final CRaSH crash;
    final Principal user;

    public GroovyShell getGroovyShell() {
        if (this.groovyShell == null) {
            CompilerConfiguration config = new CompilerConfiguration();
            config.setRecompileGroovySource(true);
            config.setScriptBaseClass(GroovyScriptCommand.class.getName());
            this.groovyShell = new GroovyShell(this.crash.context.getLoader(), new Binding(this), config);
        }
        return this.groovyShell;
    }

    public GroovyScript getLifeCycle(String name) throws NoSuchCommandException, NullPointerException {
        Class<? extends GroovyScript> scriptClass = this.crash.scriptManager.getClass(name);
        if (scriptClass != null) {
            GroovyScript script = (GroovyScript)InvokerHelper.createScript(scriptClass, new Binding(this));
            script.setBinding(new Binding(this));
            return script;
        }
        return null;
    }

    CRaSHSession(CRaSH crash, Principal user) {
        this.put("crash", crash);
        this.groovyShell = null;
        this.crash = crash;
        this.user = user;
        try {
            GroovyScript login = this.getLifeCycle("login");
            if (login != null) {
                login.setContext(this);
                login.run();
            }
        }
        catch (NoSuchCommandException e) {
            e.printStackTrace();
        }
    }

    @Override
    public Map<String, Object> getSession() {
        return this;
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.crash.context.getAttributes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        ClassLoader previous = this.setCRaSHLoader();
        try {
            GroovyScript logout = this.getLifeCycle("logout");
            if (logout != null) {
                logout.setContext(this);
                logout.run();
            }
        }
        catch (NoSuchCommandException e) {
            e.printStackTrace();
        }
        finally {
            this.setPreviousLoader(previous);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String eval(String name, String def) {
        ClassLoader previous = this.setCRaSHLoader();
        try {
            GroovyShell shell = this.getGroovyShell();
            Object ret = shell.evaluate("return " + name + ";");
            if (ret instanceof Closure) {
                log.log(Level.FINEST, "Invoking " + name + " closure");
                Closure c = (Closure)ret;
                ret = c.call();
            } else if (ret == null) {
                log.log(Level.FINEST, "No " + name + " will use empty");
                String string = def;
                return string;
            }
            String string = String.valueOf(ret);
            return string;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Could not get a " + name + " message, will use empty", e);
            String string = def;
            return string;
        }
        finally {
            this.setPreviousLoader(previous);
        }
    }

    @Override
    public String getWelcome() {
        return this.eval("welcome", "");
    }

    @Override
    public String getPrompt() {
        return this.eval("prompt", "% ");
    }

    @Override
    public ShellProcess createProcess(String request) {
        ShellResponse response;
        log.log(Level.FINE, "Invoking request " + request);
        if ("bye".equals(request) || "exit".equals(request)) {
            response = ShellResponse.close();
        } else {
            PipeLineParser parser = new PipeLineParser(request);
            PipeLineFactory factory = parser.parse();
            if (factory != null) {
                try {
                    final CommandInvoker<Void, Chunk> pipeLine = factory.create(this);
                    return new CRaSHProcess(this, request){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        ShellResponse doInvoke(ShellProcessContext context) throws InterruptedException {
                            CRaSHProcessContext invocationContext = new CRaSHProcessContext(CRaSHSession.this, context);
                            try {
                                pipeLine.open(invocationContext);
                                pipeLine.flush();
                                ShellResponse.Ok ok = ShellResponse.ok();
                                return ok;
                            }
                            catch (ScriptException e) {
                                ShellResponse.Error error = this.build(e);
                                return error;
                            }
                            catch (Throwable t) {
                                ShellResponse.Error error = this.build(t);
                                return error;
                            }
                            finally {
                                Safe.close(pipeLine);
                                Safe.close(invocationContext);
                            }
                        }

                        private ShellResponse.Error build(Throwable throwable) {
                            String result;
                            ErrorType errorType;
                            if (throwable instanceof ScriptException) {
                                errorType = ErrorType.EVALUATION;
                                Throwable cause = throwable.getCause();
                                if (cause != null) {
                                    throwable = cause;
                                }
                            } else {
                                errorType = ErrorType.INTERNAL;
                            }
                            String msg = throwable.getMessage();
                            if (throwable instanceof ScriptException) {
                                result = msg == null ? this.request + ": failed" : this.request + ": " + msg;
                                return ShellResponse.error(errorType, result, throwable);
                            }
                            if (msg == null) {
                                msg = throwable.getClass().getSimpleName();
                            }
                            result = throwable instanceof RuntimeException ? this.request + ": exception: " + msg : (throwable instanceof Exception ? this.request + ": exception: " + msg : (throwable instanceof Error ? this.request + ": error: " + msg : this.request + ": unexpected throwable: " + msg));
                            return ShellResponse.error(errorType, result, throwable);
                        }
                    };
                }
                catch (NoSuchCommandException e) {
                    response = ShellResponse.unknownCommand(e.getCommandName());
                }
            } else {
                response = ShellResponse.noCommand();
            }
        }
        return new CRaSHProcess(this, request){

            @Override
            ShellResponse doInvoke(ShellProcessContext context) throws InterruptedException {
                return response;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletionMatch complete(String prefix) {
        ClassLoader previous = this.setCRaSHLoader();
        try {
            CompletionMatch completion;
            String termPrefix;
            log.log(Level.FINE, "Want prefix of " + prefix);
            PipeLineFactory ast = new PipeLineParser(prefix).parse();
            if (ast != null) {
                PipeLineFactory last = ast.getLast();
                termPrefix = Utils.trimLeft(last.getLine());
            } else {
                termPrefix = "";
            }
            log.log(Level.FINE, "Retained term prefix is " + prefix);
            int pos = termPrefix.indexOf(32);
            if (pos == -1) {
                Completion.Builder builder = Completion.builder(prefix);
                for (String resourceId : this.crash.context.listResourceId(ResourceKind.COMMAND)) {
                    if (!resourceId.startsWith(termPrefix)) continue;
                    builder.add(resourceId.substring(termPrefix.length()), true);
                }
                completion = new CompletionMatch(Delimiter.EMPTY, builder.build());
            } else {
                String commandName = termPrefix.substring(0, pos);
                termPrefix = termPrefix.substring(pos);
                try {
                    ShellCommand command = this.crash.getCommand(commandName);
                    completion = command != null ? command.complete(new BaseRuntimeContext(this, this.crash.context.getAttributes()), termPrefix) : new CompletionMatch(Delimiter.EMPTY, Completion.create());
                }
                catch (NoSuchCommandException e) {
                    log.log(Level.FINE, "Could not create command for completion of " + prefix, e);
                    completion = new CompletionMatch(Delimiter.EMPTY, Completion.create());
                }
            }
            log.log(Level.FINE, "Found completions for " + prefix + ": " + completion);
            CompletionMatch completionMatch = completion;
            return completionMatch;
        }
        finally {
            this.setPreviousLoader(previous);
        }
    }

    ClassLoader setCRaSHLoader() {
        Thread thread = Thread.currentThread();
        ClassLoader previous = thread.getContextClassLoader();
        thread.setContextClassLoader(this.crash.context.getLoader());
        return previous;
    }

    void setPreviousLoader(ClassLoader previous) {
        Thread.currentThread().setContextClassLoader(previous);
    }
}

