/*
 * Decompiled with CFR 0.152.
 */
package org.crsh;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import junit.framework.AssertionFailedError;

public class CommandQueue
extends AbstractExecutorService {
    private final LinkedList<Runnable> queue = new LinkedList();
    private final ExecutorService delegate = Executors.newSingleThreadExecutor();

    @Override
    public synchronized void execute(Runnable command) {
        this.queue.addLast(command);
    }

    public synchronized int getSize() {
        return this.queue.size();
    }

    public synchronized Future<Runnable> executeAsync() {
        if (this.queue.size() == 0) {
            throw new AssertionFailedError();
        }
        Runnable runnable = this.queue.removeFirst();
        return this.delegate.submit(runnable, runnable);
    }

    @Override
    public void shutdown() {
        this.delegate.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.delegate.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.delegate.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.delegate.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.delegate.awaitTermination(timeout, unit);
    }
}

