/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.command;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.crsh.cli.descriptor.CommandDescriptor;
import org.crsh.cli.impl.Delimiter;
import org.crsh.cli.impl.completion.CompletionException;
import org.crsh.cli.impl.completion.CompletionMatch;
import org.crsh.cli.impl.completion.CompletionMatcher;
import org.crsh.cli.impl.descriptor.CommandDescriptorImpl;
import org.crsh.cli.impl.descriptor.HelpDescriptor;
import org.crsh.cli.impl.descriptor.IntrospectionException;
import org.crsh.cli.impl.invocation.InvocationException;
import org.crsh.cli.impl.invocation.InvocationMatch;
import org.crsh.cli.impl.invocation.InvocationMatcher;
import org.crsh.cli.impl.invocation.Resolver;
import org.crsh.cli.impl.lang.CommandFactory;
import org.crsh.cli.spi.Completer;
import org.crsh.cli.spi.Completion;
import org.crsh.command.AbstractCommand;
import org.crsh.command.CommandContext;
import org.crsh.command.CommandInvoker;
import org.crsh.command.DescriptionFormat;
import org.crsh.command.InvocationContext;
import org.crsh.command.InvocationContextImpl;
import org.crsh.command.PipeCommand;
import org.crsh.command.RuntimeContext;
import org.crsh.command.ScriptException;
import org.crsh.command.ShellCommand;
import org.crsh.command.SyntaxException;
import org.crsh.util.TypeResolver;

public abstract class BaseCommand
extends AbstractCommand
implements ShellCommand {
    private final Logger log = Logger.getLogger(this.getClass().getName());
    private final CommandDescriptorImpl<?> descriptor = HelpDescriptor.create(new CommandFactory(this.getClass().getClassLoader()).create(this.getClass()));
    protected String unmatched = null;

    protected BaseCommand() throws IntrospectionException {
    }

    public CommandDescriptor<?> getDescriptor() {
        return this.descriptor;
    }

    protected final String readLine(String msg) {
        return this.readLine(msg, true);
    }

    protected final String readLine(String msg, boolean echo) {
        if (this.context instanceof InvocationContext) {
            return ((InvocationContext)this.context).readLine(msg, echo);
        }
        throw new IllegalStateException("Cannot invoke read line without an invocation context");
    }

    public final String getUnmatched() {
        return this.unmatched;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final CompletionMatch complete(RuntimeContext context, String line) {
        CompletionMatcher<?> analyzer = this.descriptor.completer("main");
        Completer completer = this instanceof Completer ? (Completer)((Object)this) : null;
        this.context = context;
        try {
            CompletionMatch completionMatch = analyzer.match(completer, line);
            return completionMatch;
        }
        catch (CompletionException e) {
            this.log.log(Level.SEVERE, "Error during completion of line " + line, e);
            CompletionMatch completionMatch = new CompletionMatch(Delimiter.EMPTY, Completion.create());
            return completionMatch;
        }
        finally {
            this.context = null;
        }
    }

    @Override
    public final String describe(String line, DescriptionFormat mode) {
        InvocationMatch<?> match;
        InvocationMatcher<?> analyzer = this.descriptor.invoker("main");
        try {
            match = analyzer.match(line);
        }
        catch (org.crsh.cli.SyntaxException e) {
            throw new SyntaxException(e.getMessage());
        }
        try {
            switch (mode) {
                case DESCRIBE: {
                    return match.getDescriptor().getUsage();
                }
                case MAN: {
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    match.getDescriptor().printMan(pw);
                    return sw.toString();
                }
                case USAGE: {
                    StringWriter sw2 = new StringWriter();
                    PrintWriter pw2 = new PrintWriter(sw2);
                    match.getDescriptor().printUsage(pw2);
                    return sw2.toString();
                }
            }
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        return null;
    }

    @Override
    public CommandInvoker<?, ?> resolveInvoker(String name, Map<String, ?> options, List<?> args) {
        if (options.containsKey("h") || options.containsKey("help")) {
            throw new UnsupportedOperationException("Implement me");
        }
        InvocationMatcher<?> matcher = this.descriptor.invoker("main");
        InvocationMatch<BaseCommand> match = null;
        try {
            match = matcher.match(name, options, args);
        }
        catch (org.crsh.cli.SyntaxException e) {
            throw new SyntaxException(e.getMessage());
        }
        return this.resolveInvoker(match);
    }

    public ScriptException toScript(Throwable cause) {
        if (cause instanceof ScriptException) {
            return (ScriptException)cause;
        }
        return new ScriptException(cause);
    }

    @Override
    public CommandInvoker<?, ?> resolveInvoker(String line) {
        InvocationMatch<BaseCommand> match;
        InvocationMatcher<?> analyzer = this.descriptor.invoker("main");
        try {
            match = analyzer.match(line);
        }
        catch (org.crsh.cli.SyntaxException e) {
            throw new SyntaxException(e.getMessage());
        }
        return this.resolveInvoker(match);
    }

    public final void execute(String s) throws ScriptException, IOException {
        InvocationContext<?> context = this.peekContext();
        CommandInvoker<?, ?> invoker = context.resolve(s);
        invoker.open(context);
        invoker.flush();
        invoker.close();
    }

    public final CommandInvoker<?, ?> resolveInvoker(final InvocationMatch<BaseCommand> match) {
        Class producedType;
        Class consumedType;
        final org.crsh.cli.impl.invocation.CommandInvoker<BaseCommand> invoker = match.getInvoker();
        if (PipeCommand.class.isAssignableFrom(invoker.getReturnType())) {
            Type ret = invoker.getGenericReturnType();
            consumedType = TypeResolver.resolveToClass(ret, PipeCommand.class, 0);
            producedType = TypeResolver.resolveToClass(ret, PipeCommand.class, 1);
        } else {
            consumedType = Void.class;
            producedType = Object.class;
            Class<?>[] parameterTypes = invoker.getParameterTypes();
            for (int i = 0; i < parameterTypes.length; ++i) {
                Class<?> parameterType = parameterTypes[i];
                if (!InvocationContext.class.isAssignableFrom(parameterType)) continue;
                Type contextGenericParameterType = invoker.getGenericParameterTypes()[i];
                producedType = TypeResolver.resolveToClass(contextGenericParameterType, InvocationContext.class, 0);
                break;
            }
        }
        final Class _consumedType = consumedType;
        final Class _producedType = producedType;
        return new CommandInvoker<Object, Object>(){
            PipeCommand real;

            @Override
            public Class<Object> getProducedType() {
                return _producedType;
            }

            @Override
            public Class<Object> getConsumedType() {
                return _consumedType;
            }

            @Override
            public void open(CommandContext<Object> consumer) {
                Object ret;
                final InvocationContextImpl<Object> invocationContext = new InvocationContextImpl<Object>(consumer);
                Resolver resolver = new Resolver(){

                    @Override
                    public <T> T resolve(Class<T> type) {
                        if (type.equals(InvocationContext.class)) {
                            return type.cast(invocationContext);
                        }
                        return null;
                    }
                };
                BaseCommand.this.pushContext(invocationContext);
                BaseCommand.this.unmatched = match.getRest();
                try {
                    ret = invoker.invoke(resolver, BaseCommand.this);
                }
                catch (org.crsh.cli.SyntaxException e) {
                    throw new SyntaxException(e.getMessage());
                }
                catch (InvocationException e) {
                    throw BaseCommand.this.toScript(e.getCause());
                }
                if (ret instanceof PipeCommand) {
                    this.real = (PipeCommand)ret;
                    this.real.doOpen(invocationContext);
                } else if (ret != null) {
                    BaseCommand.this.peekContext().getWriter().print(ret);
                }
            }

            @Override
            public void provide(Object element) throws IOException {
                if (this.real != null) {
                    this.real.provide(element);
                }
            }

            @Override
            public void flush() throws IOException {
                if (this.real != null) {
                    this.real.flush();
                } else {
                    BaseCommand.this.peekContext().flush();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void close() throws IOException {
                if (this.real != null) {
                    try {
                        this.real.close();
                    }
                    finally {
                        BaseCommand.this.popContext();
                    }
                } else {
                    InvocationContext<?> context = BaseCommand.this.popContext();
                    context.close();
                }
                BaseCommand.this.unmatched = null;
            }
        };
    }
}

