/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.plugin;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.crsh.plugin.Property;

public abstract class PropertyDescriptor<T> {
    public static final String SECRET_DISPLAY_VALUE = "*****";
    private static final Map<String, PropertyDescriptor<?>> INTERNAL_ALL = new HashMap();
    public static final Map<String, PropertyDescriptor<?>> ALL = Collections.unmodifiableMap(INTERNAL_ALL);
    public static final PropertyDescriptor<TimeUnit> VFS_REFRESH_UNIT = new PropertyDescriptor<TimeUnit>(TimeUnit.class, "vfs.refresh_unit", TimeUnit.SECONDS, "The refresh time unit"){

        @Override
        public TimeUnit doParse(String s) {
            return TimeUnit.valueOf(s);
        }
    };
    public static final PropertyDescriptor<Integer> VFS_REFRESH_PERIOD = PropertyDescriptor.create("vfs.refresh_period", (Integer)null, "The refresh rate period");
    public final Class<T> type;
    public final String name;
    public final T defaultValue;
    public final String description;
    public final boolean secret;

    public static PropertyDescriptor<String> create(String name, String defaultValue, String description, boolean secret) {
        return new PropertyDescriptor<String>(String.class, name, defaultValue, description, secret){

            @Override
            protected String doParse(String s) throws Exception {
                return s;
            }
        };
    }

    public static PropertyDescriptor<String> create(String name, String defaultValue, String description) {
        return PropertyDescriptor.create(name, defaultValue, description, false);
    }

    public static PropertyDescriptor<Integer> create(String name, Integer defaultValue, String description, boolean secret) {
        return new PropertyDescriptor<Integer>(Integer.class, name, defaultValue, description, secret){

            @Override
            protected Integer doParse(String s) throws Exception {
                return Integer.parseInt(s);
            }
        };
    }

    public static PropertyDescriptor<Integer> create(String name, Integer defaultValue, String description) {
        return PropertyDescriptor.create(name, defaultValue, description, false);
    }

    protected PropertyDescriptor(Class<T> type, String name, T defaultValue, String description) throws NullPointerException {
        this(type, name, defaultValue, description, false);
    }

    protected PropertyDescriptor(Class<T> type, String name, T defaultValue, String description, boolean secret) throws NullPointerException {
        if (type == null) {
            throw new NullPointerException("No null type accepted");
        }
        if (name == null) {
            throw new NullPointerException("No null name accepted");
        }
        if (description == null) {
            throw new NullPointerException("No null description accepted");
        }
        this.type = type;
        this.name = name;
        this.defaultValue = defaultValue;
        this.description = description;
        this.secret = secret;
        INTERNAL_ALL.put(name, this);
    }

    public final String getName() {
        return this.name;
    }

    public final String getDescription() {
        return this.description;
    }

    public final Class<T> getType() {
        return this.type;
    }

    public final T getDefaultValue() {
        return this.defaultValue;
    }

    public final String getDefaultDisplayValue() {
        return this.secret ? SECRET_DISPLAY_VALUE : String.valueOf(this.defaultValue);
    }

    public final T parse(String s) throws NullPointerException, IllegalArgumentException {
        if (s == null) {
            throw new NullPointerException("Cannot parse null property values");
        }
        try {
            return this.doParse(s);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Illegal property value " + s, e);
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof PropertyDescriptor) {
            PropertyDescriptor that = (PropertyDescriptor)obj;
            return this.name.equals(that.name) && this.type.equals(that.type);
        }
        return false;
    }

    public final Property<T> toProperty(String s) throws NullPointerException, IllegalArgumentException {
        T value = this.parse(s);
        return new Property<T>(this, value);
    }

    protected abstract T doParse(String var1) throws Exception;

    public final String toString() {
        return "PropertyDescriptor[name=" + this.name + ",type=" + this.type.getName() + ",description=" + this.description + "]";
    }
}

