/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.lang.groovy.closure;

import groovy.lang.Closure;
import groovy.lang.GroovyObjectSupport;
import groovy.lang.MissingMethodException;
import groovy.lang.MissingPropertyException;
import groovy.lang.Tuple;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.runtime.MetaClassHelper;
import org.crsh.command.CommandInvoker;
import org.crsh.command.InvocationContext;
import org.crsh.command.ShellCommand;
import org.crsh.lang.groovy.closure.ClosureElement;
import org.crsh.lang.groovy.closure.CommandElement;
import org.crsh.lang.groovy.closure.PipeLineElement;
import org.crsh.lang.groovy.closure.PipeLineInvoker;
import org.crsh.util.Utils;

public class PipeLineClosure
extends Closure {
    private static final Object[] EMPTY_ARGS = new Object[0];
    private final InvocationContext<Object> context;
    private PipeLineElement[] elements;

    public PipeLineClosure(InvocationContext<Object> context, String name, ShellCommand command) {
        this(context, new CommandElement[]{new CommandElement(name, command, null)});
    }

    public PipeLineClosure(InvocationContext<Object> context, PipeLineElement[] elements) {
        super(new Object());
        this.context = context;
        this.elements = elements;
    }

    public Object find() {
        return this._gdk("find", EMPTY_ARGS);
    }

    public Object find(Closure closure) {
        return this._gdk("find", new Object[]{closure});
    }

    private Object _gdk(String name, Object[] args) {
        PipeLineClosure find = this._sub(name);
        if (find != null) {
            return find.call(args);
        }
        throw new MissingMethodException(name, PipeLineClosure.class, args);
    }

    public Object or(Object t) {
        if (t instanceof PipeLineClosure) {
            PipeLineClosure next = (PipeLineClosure)t;
            PipeLineElement[] combined = Arrays.copyOf(this.elements, this.elements.length + next.elements.length);
            System.arraycopy(next.elements, 0, combined, this.elements.length, next.elements.length);
            return new PipeLineClosure(this.context, combined);
        }
        if (t instanceof Closure) {
            Closure closure = (Closure)t;
            PipeLineElement[] combined = new PipeLineElement[this.elements.length + 1];
            System.arraycopy(this.elements, 0, combined, 0, this.elements.length);
            combined[this.elements.length] = new ClosureElement(closure);
            return new PipeLineClosure(this.context, combined);
        }
        throw new UnsupportedOperationException("Not supported");
    }

    private PipeLineClosure _sub(String name) {
        if (this.elements.length == 1) {
            CommandElement element = (CommandElement)this.elements[0];
            if (element.name == null) {
                return new PipeLineClosure(this.context, new CommandElement[]{new CommandElement(element.commandName + "." + name, element.command, name)});
            }
        }
        return null;
    }

    @Override
    public Object getProperty(String property) {
        try {
            return super.getProperty(property);
        }
        catch (MissingPropertyException e) {
            PipeLineClosure sub = this._sub(property);
            if (sub != null) {
                return sub;
            }
            throw e;
        }
    }

    @Override
    public Object invokeMethod(String name, Object args) {
        try {
            return super.invokeMethod(name, args);
        }
        catch (MissingMethodException e) {
            PipeLineClosure sub = this._sub(name);
            if (sub != null) {
                return sub.call((Object[])args);
            }
            throw e;
        }
    }

    private static Object[] unwrapArgs(Object arguments) {
        if (arguments == null) {
            return MetaClassHelper.EMPTY_ARRAY;
        }
        if (arguments instanceof Tuple) {
            Tuple tuple = (Tuple)arguments;
            return tuple.toArray();
        }
        if (arguments instanceof Object[]) {
            return (Object[])arguments;
        }
        return new Object[]{arguments};
    }

    private PipeLineClosure options(Map<String, ?> options, Object[] arguments) {
        CommandElement first = (CommandElement)this.elements[0];
        Map<String, Object> firstOptions = first.options;
        List<Object> firstArgs = first.args;
        if (options != null && options.size() > 0) {
            firstOptions = firstOptions == null ? new HashMap<String, Object>() : new HashMap(options);
            for (Map.Entry<String, ?> arg : options.entrySet()) {
                firstOptions.put(arg.getKey().toString(), arg.getValue());
            }
        }
        if (arguments != null) {
            firstArgs = new ArrayList<Object>(Arrays.asList(arguments));
        }
        PipeLineElement[] ret = (PipeLineElement[])this.elements.clone();
        ret[0] = new CommandElement(first.commandName, first.command, first.name, firstOptions, firstArgs);
        return new PipeLineClosure(this.context, ret);
    }

    public Object call(Object ... args) {
        int to = args.length;
        Closure closure = to > 0 && args[to - 1] instanceof Closure ? (Closure)args[--to] : null;
        if (closure != null) {
            Object[] closureArgs;
            final HashMap closureOptions = new HashMap();
            GroovyObjectSupport delegate = new GroovyObjectSupport(){

                @Override
                public void setProperty(String property, Object newValue) {
                    closureOptions.put(property, newValue);
                }
            };
            closure.setResolveStrategy(3);
            closure.setDelegate(delegate);
            Object ret = closure.call();
            if (ret != null) {
                if (ret instanceof Object[]) {
                    closureArgs = (Object[])ret;
                } else if (ret instanceof Iterable) {
                    closureArgs = Utils.list((Iterable)ret).toArray();
                } else {
                    Object[] objectArray;
                    boolean use = true;
                    for (Object value : closureOptions.values()) {
                        if (value != ret) continue;
                        use = false;
                        break;
                    }
                    if (use) {
                        Object[] objectArray2 = new Object[1];
                        objectArray = objectArray2;
                        objectArray2[0] = ret;
                    } else {
                        objectArray = EMPTY_ARGS;
                    }
                    closureArgs = objectArray;
                }
            } else {
                closureArgs = EMPTY_ARGS;
            }
            return this.options(closureOptions, closureArgs);
        }
        PipeLineInvoker binding = this.bind(args);
        if (this.context != null) {
            try {
                binding.invoke(this.context);
                return null;
            }
            catch (Exception e) {
                return PipeLineClosure.throwRuntimeException(e);
            }
        }
        return binding;
    }

    public PipeLineClosure bind(InvocationContext<Object> context) {
        return new PipeLineClosure(context, this.elements);
    }

    public PipeLineInvoker bind(Object args) {
        return this.bind(PipeLineClosure.unwrapArgs(args));
    }

    public PipeLineInvoker bind(Object[] args) {
        return new PipeLineInvoker(this, args);
    }

    LinkedList<CommandInvoker> resolve2(Object[] args) {
        Object first;
        List<Object> invokerArgs;
        CommandElement elt = (CommandElement)this.elements[0];
        Map<String, Object> invokerOptions = elt.options != null ? elt.options : Collections.emptyMap();
        List<Object> list = invokerArgs = elt.args != null ? elt.args : Collections.emptyList();
        if (args.length > 0) {
            int from;
            first = args[0];
            if (first instanceof Map) {
                from = 1;
                Map options = (Map)first;
                if (options.size() > 0) {
                    invokerOptions = new HashMap(invokerOptions);
                    for (Map.Entry option : options.entrySet()) {
                        String optionName = option.getKey().toString();
                        Object optionValue = option.getValue();
                        invokerOptions.put(optionName, optionValue);
                    }
                }
            } else {
                from = 0;
            }
            if (from < args.length) {
                invokerArgs = new ArrayList(invokerArgs);
                while (from < args.length) {
                    Object o;
                    if ((o = args[from++]) == null) continue;
                    invokerArgs.add(o);
                }
            }
        }
        first = (CommandElement)this.elements[0];
        PipeLineElement[] a = (PipeLineElement[])this.elements.clone();
        a[0] = new CommandElement(((CommandElement)first).commandName, ((CommandElement)first).command, ((CommandElement)first).name, invokerOptions, invokerArgs);
        LinkedList<CommandInvoker> ret = new LinkedList<CommandInvoker>();
        for (PipeLineElement _elt : a) {
            ret.add(_elt.make());
        }
        return ret;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.elements.length; ++i) {
            if (i > 0) {
                sb.append(" | ");
            }
            this.elements[i].toString(sb);
        }
        return sb.toString();
    }
}

