/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.vfs;

import java.io.InputStream;
import java.net.URL;
import java.util.Iterator;
import junit.framework.TestCase;
import org.crsh.util.IO;
import org.crsh.vfs.FS;
import org.crsh.vfs.File;
import org.crsh.vfs.Path;
import org.crsh.vfs.spi.ram.RAMDriver;
import org.crsh.vfs.spi.url.Node;
import org.crsh.vfs.spi.url.URLDriver;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;

public class FSTestCase
extends TestCase {
    public void testFoo() throws Exception {
        FS fs = new FS().mount(FSTestCase.class);
        File root = fs.get(Path.get((String)"/"));
        File org = root.child("org", true);
        FSTestCase.assertEquals((String)"org", (String)org.getName());
        FSTestCase.assertEquals((boolean)true, (boolean)org.isDir());
        Iterator orgChildren = org.children().iterator();
        File crsh = (File)orgChildren.next();
        FSTestCase.assertFalse((boolean)orgChildren.hasNext());
        FSTestCase.assertEquals((String)"crsh", (String)crsh.getName());
        FSTestCase.assertEquals((boolean)true, (boolean)crsh.isDir());
    }

    public void testJar() throws Exception {
        java.io.File file = java.io.File.createTempFile("test", ".jar");
        file.deleteOnExit();
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class);
        archive.addClass(FSTestCase.class);
        ZipExporter exporter = (ZipExporter)archive.as(ZipExporter.class);
        exporter.exportTo(file, true);
        URLDriver driver = new URLDriver();
        driver.merge(file.toURI().toURL());
        Node root = driver.root();
        FSTestCase.assertEquals((String)"", (String)driver.name(root));
        FSTestCase.assertTrue((boolean)driver.isDir(root));
        Iterator rootChildren = driver.children(root).iterator();
        Node org = (Node)rootChildren.next();
        FSTestCase.assertFalse((boolean)rootChildren.hasNext());
        FSTestCase.assertEquals((String)"org", (String)driver.name(org));
        FSTestCase.assertTrue((boolean)driver.isDir(org));
        Iterator orgChildren = driver.children(org).iterator();
        Node crsh = (Node)orgChildren.next();
        FSTestCase.assertFalse((boolean)orgChildren.hasNext());
        FSTestCase.assertEquals((String)"crsh", (String)driver.name(crsh));
        FSTestCase.assertTrue((boolean)driver.isDir(crsh));
        Iterator vfsChildren = driver.children(crsh).iterator();
        Node vfs = (Node)vfsChildren.next();
        FSTestCase.assertFalse((boolean)vfsChildren.hasNext());
        FSTestCase.assertEquals((String)"vfs", (String)driver.name(vfs));
        FSTestCase.assertTrue((boolean)driver.isDir(vfs));
        Iterator clazzChildren = driver.children(vfs).iterator();
        Node clazz = (Node)clazzChildren.next();
        FSTestCase.assertFalse((boolean)clazzChildren.hasNext());
        FSTestCase.assertEquals((String)(FSTestCase.class.getSimpleName() + ".class"), (String)driver.name(clazz));
        FSTestCase.assertFalse((boolean)driver.isDir(clazz));
        Iterator in = driver.open(clazz);
        FSTestCase.assertTrue((boolean)in.hasNext());
        ((InputStream)in.next()).close();
        FSTestCase.assertFalse((boolean)in.hasNext());
    }

    public void testNestedJar() throws Exception {
        java.io.File file = java.io.File.createTempFile("test", ".war");
        file.deleteOnExit();
        JavaArchive jar = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"foo.jar");
        jar.addClass(FSTestCase.class);
        WebArchive war = (WebArchive)ShrinkWrap.create(WebArchive.class);
        war.addAsLibraries(new Archive[]{jar});
        ZipExporter exporter = (ZipExporter)war.as(ZipExporter.class);
        exporter.exportTo(file, true);
        URL url = new URL("jar:" + file.toURI().toURL() + "!/WEB-INF/lib/foo.jar");
        URLDriver driver = new URLDriver();
        driver.merge(new URL("jar:" + file.toURI().toURL() + "!/WEB-INF/"));
        Node root = driver.root();
        Node lib = (Node)driver.child((Object)root, "lib");
        Node foo_jar = (Node)driver.child((Object)lib, "foo.jar");
        FSTestCase.assertNotNull((Object)foo_jar);
        Iterator in = driver.open(foo_jar);
        FSTestCase.assertNotNull((Object)in);
        FSTestCase.assertTrue((boolean)in.hasNext());
        byte[] bytes = IO.readAsBytes((InputStream)((InputStream)in.next()));
        FSTestCase.assertFalse((boolean)in.hasNext());
        url = new URL("jar:" + url + "!/org/crsh/");
        driver = new URLDriver();
        driver.merge(url);
        root = driver.root();
        Node vfs = (Node)driver.child((Object)root, "vfs");
        Node FSTestCase_class = (Node)driver.child((Object)vfs, "FSTestCase.class");
        FSTestCase.assertNotNull((Object)FSTestCase_class);
        in = driver.open(FSTestCase_class);
        FSTestCase.assertNotNull((Object)in);
        FSTestCase.assertTrue((boolean)in.hasNext());
        bytes = IO.readAsBytes((InputStream)((InputStream)in.next()));
        FSTestCase.assertFalse((boolean)in.hasNext());
    }

    public void testDuplicateResource() throws Exception {
        java.io.File file = java.io.File.createTempFile("test", ".jar");
        file.deleteOnExit();
        JavaArchive jar = (JavaArchive)ShrinkWrap.create(JavaArchive.class);
        jar.addClass(FSTestCase.class);
        ((ZipExporter)jar.as(ZipExporter.class)).exportTo(file, true);
        URLDriver driver = new URLDriver();
        driver.merge(file.toURI().toURL());
        driver.merge(file.toURI().toURL());
        Node node = (Node)driver.child(driver.child(driver.child(driver.child((Object)driver.root(), "org"), "crsh"), "vfs"), "FSTestCase.class");
        Iterator i = driver.open(node);
        FSTestCase.assertTrue((boolean)i.hasNext());
        i.next();
        FSTestCase.assertTrue((boolean)i.hasNext());
        i.next();
        FSTestCase.assertFalse((boolean)i.hasNext());
    }

    public void testRAM() throws Exception {
        RAMDriver driver = new RAMDriver();
        driver.add("/foo", "bar");
        Path root = driver.root();
        FSTestCase.assertEquals((Object)Path.get((String)"/"), (Object)root);
        Path foo = (Path)driver.child((Object)root, "foo");
        FSTestCase.assertNotNull((Object)foo);
        Iterator in = driver.open(foo);
        FSTestCase.assertTrue((boolean)in.hasNext());
        String file = IO.readAsUTF8((InputStream)((InputStream)in.next()));
        FSTestCase.assertFalse((boolean)in.hasNext());
        FSTestCase.assertEquals((String)"bar", (String)file);
    }
}

