/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.spring;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import org.crsh.plugin.PluginContext;
import org.crsh.plugin.PluginDiscovery;
import org.crsh.plugin.PluginLifeCycle;
import org.crsh.spring.SpringMap;
import org.crsh.spring.SpringPluginDiscovery;
import org.crsh.vfs.FS;
import org.crsh.vfs.Path;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ListableBeanFactory;

public class SpringBootstrap
extends PluginLifeCycle
implements BeanClassLoaderAware,
BeanFactoryAware,
InitializingBean,
DisposableBean {
    private ClassLoader loader;
    private BeanFactory factory;

    public void setBeanClassLoader(ClassLoader loader) {
        this.loader = loader;
    }

    public void setBeanFactory(BeanFactory factory) throws BeansException {
        this.factory = factory;
    }

    public void afterPropertiesSet() throws Exception {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("factory", this.factory);
        if (this.factory instanceof ListableBeanFactory) {
            ListableBeanFactory listable = (ListableBeanFactory)this.factory;
            attributes.put("beans", (Object)new SpringMap(listable));
        }
        SpringPluginDiscovery discovery = new SpringPluginDiscovery(this.loader, this.factory);
        FS cmdFS = this.createCommandFS();
        FS confFS = this.createConfFS();
        PluginContext context = new PluginContext((PluginDiscovery)discovery, Collections.unmodifiableMap(attributes), cmdFS, confFS, this.loader);
        context.refresh();
        this.start(context);
    }

    protected FS createCommandFS() throws IOException, URISyntaxException {
        FS cmdFS = new FS();
        cmdFS.mount(this.loader, Path.get((String)"/crash/commands/"));
        return cmdFS;
    }

    protected FS createConfFS() throws IOException, URISyntaxException {
        FS confFS = new FS();
        confFS.mount(this.loader, Path.get((String)"/crash/"));
        return confFS;
    }

    public void destroy() throws Exception {
        this.stop();
    }
}

