/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.plugin;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.crsh.plugin.PluginContext;
import org.crsh.plugin.PluginLifeCycle;
import org.crsh.plugin.ServiceLoaderDiscovery;
import org.crsh.vfs.FS;
import org.crsh.vfs.spi.servlet.ServletContextDriver;

public class WebPluginLifeCycle
extends PluginLifeCycle
implements ServletContextListener {
    private static final Object lock = new Object();
    private static final Map<String, PluginContext> contextMap = new HashMap<String, PluginContext>();
    private boolean registered = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PluginContext getPluginContext(ServletContext sc) throws NullPointerException {
        String contextPath = sc.getContextPath();
        Object object = lock;
        synchronized (object) {
            return contextMap.get(contextPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contextInitialized(ServletContextEvent sce) {
        ServletContext sc = sce.getServletContext();
        String contextPath = sc.getContextPath();
        this.setConfig(System.getProperties());
        Object object = lock;
        synchronized (object) {
            if (!contextMap.containsKey(contextPath)) {
                FS binFS = new FS().mount(new ServletContextDriver(sc), "/WEB-INF/crash/commands/");
                FS confFS = new FS().mount(new ServletContextDriver(sc), "/WEB-INF/crash/");
                ClassLoader webAppLoader = Thread.currentThread().getContextClassLoader();
                PluginContext context = new PluginContext(new ServiceLoaderDiscovery(webAppLoader), binFS, confFS, webAppLoader);
                contextMap.put(contextPath, context);
                this.registered = true;
                this.start(context);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contextDestroyed(ServletContextEvent sce) {
        if (this.registered) {
            ServletContext sc = sce.getServletContext();
            String contextPath = sc.getContextPath();
            Object object = lock;
            synchronized (object) {
                contextMap.remove(contextPath);
                this.registered = false;
                this.stop();
            }
        }
    }
}

