/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.vfs.spi.ram;

import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.crsh.vfs.Path;
import org.crsh.vfs.spi.AbstractFSDriver;
import org.crsh.vfs.spi.ram.RAMURLStreamHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RAMDriver
extends AbstractFSDriver<Path> {
    private final Path root;
    final HashMap<Path, String> entries;
    URL baseURL;

    public RAMDriver() {
        try {
            this.root = Path.get("/");
            this.entries = new HashMap();
            this.baseURL = new URL("ram", null, 0, "/", new RAMURLStreamHandler(this));
        }
        catch (MalformedURLException e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    public void add(String path, String file) {
        this.add(Path.get(path), file);
    }

    public void add(Path path, String file) {
        this.entries.put(path, file);
    }

    @Override
    public Path root() throws IOException {
        return this.root;
    }

    @Override
    public String name(Path handle) throws IOException {
        return handle.getName();
    }

    @Override
    public boolean isDir(Path handle) throws IOException {
        return handle.isDir();
    }

    @Override
    public Iterable<Path> children(Path handle) throws IOException {
        List<Path> children = Collections.emptyList();
        for (Path entry : this.entries.keySet()) {
            if (!entry.isChildOf(handle)) continue;
            if (children.isEmpty()) {
                children = new ArrayList<Path>();
            }
            children.add(entry);
        }
        return children;
    }

    @Override
    public URL toURL(Path handle) throws IOException {
        return new URL(this.baseURL, handle.getValue());
    }
}

