/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.shell.ui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import org.crsh.command.InvocationContext;
import org.crsh.shell.io.ShellWriter;
import org.crsh.shell.io.ShellWriterContext;
import org.crsh.shell.ui.FormattingElement;
import org.crsh.shell.ui.Pad;
import org.crsh.text.Style;

class UIWriterContext
implements ShellWriterContext {
    final ArrayList<Pad> stack;
    Style padStyle;
    boolean needLF;
    boolean needLine;
    private final InvocationContext context;
    String leftLinePadding = "";
    String rightLinePadding = "";
    UIWriterContext parentUIContext;
    private static EnumMap<Pad, String> charMap = new EnumMap(Pad.class);
    private static EnumMap<Pad, Pad> nextMap = new EnumMap(Pad.class);

    UIWriterContext(InvocationContext context) {
        this.context = context;
        this.stack = new ArrayList();
        this.needLF = false;
    }

    UIWriterContext(UIWriterContext parentUIContext) {
        this(parentUIContext.getInvocationContext());
        this.parentUIContext = parentUIContext;
    }

    public void pad(ShellWriter writer) throws IOException {
        for (int i = 0; i < this.stack.size(); ++i) {
            Pad abc = this.stack.get(i);
            if (this.padStyle != null) {
                new FormattingElement(this.padStyle).print(this, writer);
            }
            writer.append(charMap.get((Object)abc));
            if (this.padStyle != null) {
                new FormattingElement(Style.reset).print(this, writer);
            }
            Pad next = nextMap.get((Object)abc);
            this.stack.set(i, next);
        }
        this.stack.removeAll(Collections.singleton(null));
    }

    public void printLine(int length, ShellWriter writer) throws IOException {
        writer.append(" ");
        for (int i = 0; i < length; ++i) {
            writer.append("-");
        }
        writer.append("\n");
    }

    public void text(CharSequence csq, int off, int end) {
        this.needLF = true;
    }

    public void lineFeed() {
        this.needLF = false;
    }

    public int getConsoleWidth() {
        return this.context.getWidth();
    }

    public InvocationContext getInvocationContext() {
        return this.context;
    }

    public int padWidth() {
        int width = this.leftLinePadding.length() + this.rightLinePadding.length();
        for (Pad pad : this.stack) {
            String p = charMap.get((Object)pad);
            if (p == null) continue;
            width += p.length();
        }
        return width;
    }

    static {
        charMap.put(Pad.BRANCH, "+-");
        charMap.put(Pad.LAST_BRANCH, "+-");
        charMap.put(Pad.CONTINUE_BRANCH, "| ");
        charMap.put(Pad.STOP_BRANCH, "  ");
        charMap.put(Pad.SPACE, " ");
        nextMap.put(Pad.BRANCH, Pad.CONTINUE_BRANCH);
        nextMap.put(Pad.CONTINUE_BRANCH, Pad.CONTINUE_BRANCH);
        nextMap.put(Pad.LAST_BRANCH, Pad.STOP_BRANCH);
        nextMap.put(Pad.STOP_BRANCH, Pad.STOP_BRANCH);
    }
}

