/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.cmdline;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.Map;
import java.util.Set;
import org.crsh.cmdline.ArgumentDescriptor;
import org.crsh.cmdline.ClassDescriptor;
import org.crsh.cmdline.CommandDescriptor;
import org.crsh.cmdline.Description;
import org.crsh.cmdline.IntrospectionException;
import org.crsh.cmdline.OptionDescriptor;
import org.crsh.cmdline.ParameterDescriptor;
import org.crsh.cmdline.Util;
import org.crsh.cmdline.binding.MethodArgumentBinding;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodDescriptor<T>
extends CommandDescriptor<T, MethodArgumentBinding> {
    private static final Set<String> MAIN_SINGLETON = Collections.singleton("main");
    private static final Logger log = LoggerFactory.getLogger(MethodDescriptor.class);
    private final ClassDescriptor<T> owner;
    private final Method method;
    private final int size;

    MethodDescriptor(ClassDescriptor<T> owner, Method method, String name, Description info) throws IntrospectionException {
        super(name, info);
        this.owner = owner;
        this.method = method;
        this.size = method.getParameterTypes().length;
    }

    public ParameterDescriptor<MethodArgumentBinding> getParameter(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("Bad index value " + index);
        }
        for (ParameterDescriptor<MethodArgumentBinding> parameterDescriptor : this.getParameters()) {
            if (((MethodArgumentBinding)parameterDescriptor.getBinding()).getIndex() != index) continue;
            return parameterDescriptor;
        }
        return null;
    }

    @Override
    public Map<String, ? extends CommandDescriptor<T, ?>> getSubordinates() {
        return Collections.emptyMap();
    }

    public Method getMethod() {
        return this.method;
    }

    @Override
    public Class<T> getType() {
        return this.owner.getType();
    }

    @Override
    public OptionDescriptor<?> findOption(String name) {
        OptionDescriptor<Object> option = this.getOption(name);
        if (option == null) {
            option = this.owner.findOption(name);
        }
        return option;
    }

    @Override
    public void printUsage(Appendable writer) throws IOException {
        String usage;
        StringBuilder sb;
        int length = 0;
        ArrayList<String> parameterUsages = new ArrayList<String>();
        ArrayList<String> parameterBilto = new ArrayList<String>();
        boolean printName = !((Object)this.owner.getSubordinates().keySet()).equals(MAIN_SINGLETON);
        writer.append("usage: ").append(this.owner.getName());
        for (OptionDescriptor optionDescriptor : this.owner.getOptions()) {
            writer.append(" ");
            sb = new StringBuilder();
            optionDescriptor.printUsage(sb);
            usage = sb.toString();
            writer.append(usage);
            length = Math.max(length, usage.length());
            parameterUsages.add(usage);
            parameterBilto.add(optionDescriptor.getUsage());
        }
        writer.append(printName ? " " + this.getName() : "");
        for (ParameterDescriptor parameterDescriptor : this.getParameters()) {
            writer.append(" ");
            sb = new StringBuilder();
            parameterDescriptor.printUsage(sb);
            usage = sb.toString();
            writer.append(usage);
            length = Math.max(length, usage.length());
            parameterBilto.add(parameterDescriptor.getUsage());
            parameterUsages.add(usage);
        }
        writer.append("\n\n");
        String format = "   %1$-" + length + "s %2$s\n";
        for (String[] tuple : Util.tuples(String.class, parameterUsages, parameterBilto)) {
            Formatter formatter = new Formatter(writer);
            formatter.format(format, tuple[0], tuple[1]);
        }
        writer.append("\n\n");
    }

    @Override
    public void printMan(Appendable writer) throws IOException {
        boolean printName = !((Object)this.owner.getSubordinates().keySet()).equals(MAIN_SINGLETON);
        writer.append("NAME\n");
        writer.append(Util.MAN_TAB).append(this.owner.getName());
        if (printName) {
            writer.append(" ").append(this.getName());
        }
        if (this.getUsage().length() > 0) {
            writer.append(" - ").append(this.getUsage());
        }
        writer.append("\n\n");
        writer.append("SYNOPSIS\n");
        writer.append(Util.MAN_TAB).append(this.owner.getName());
        for (OptionDescriptor optionDescriptor : this.owner.getOptions()) {
            writer.append(" ");
            optionDescriptor.printUsage(writer);
        }
        if (printName) {
            writer.append(" ").append(this.getName());
        }
        for (OptionDescriptor optionDescriptor : this.getOptions()) {
            writer.append(" ");
            optionDescriptor.printUsage(writer);
        }
        for (ArgumentDescriptor argumentDescriptor : this.getArguments()) {
            writer.append(" ");
            argumentDescriptor.printUsage(writer);
        }
        writer.append("\n\n");
        String man = this.getDescription().getMan();
        if (man.length() > 0) {
            writer.append("DESCRIPTION\n");
            Util.indent(Util.MAN_TAB, (CharSequence)man, writer);
            writer.append("\n\n");
        }
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.owner.getOptions());
        arrayList.addAll(this.getOptions());
        if (arrayList.size() > 0) {
            writer.append("\nPARAMETERS\n");
            for (ParameterDescriptor parameter : Util.join(this.owner.getOptions(), this.getParameters())) {
                writer.append(Util.MAN_TAB);
                parameter.printUsage(writer);
                String parameterText = parameter.getDescription().getBestEffortMan();
                if (parameterText.length() > 0) {
                    writer.append("\n");
                    Util.indent(Util.MAN_TAB_EXTRA, (CharSequence)parameterText, writer);
                }
                writer.append("\n\n");
            }
        }
    }
}

