/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.cmdline;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import org.crsh.cmdline.CommandDescriptor;
import org.crsh.cmdline.Description;
import org.crsh.cmdline.IllegalParameterException;
import org.crsh.cmdline.IllegalValueTypeException;
import org.crsh.cmdline.Multiplicity;
import org.crsh.cmdline.SimpleValueType;
import org.crsh.cmdline.binding.TypeBinding;
import org.crsh.cmdline.completers.EmptyCompleter;
import org.crsh.cmdline.matcher.CmdSyntaxException;
import org.crsh.cmdline.spi.Completer;
import org.crsh.cmdline.spi.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ParameterDescriptor<B extends TypeBinding> {
    private final B binding;
    private final Description description;
    private final SimpleValueType type;
    private final Multiplicity multiplicity;
    private final boolean required;
    private final boolean password;
    private final Type javaType;
    private final Class<?> javaValueType;
    private final Class<? extends Completer> completerType;
    private final Annotation annotation;
    private final boolean unquote;
    CommandDescriptor<?, B> owner;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ParameterDescriptor(B binding, Type javaType, Description description, boolean required, boolean password, boolean unquote, Class<? extends Completer> completerType, Annotation annotation) throws IllegalValueTypeException, IllegalParameterException {
        SimpleValueType<Object> valueType;
        Multiplicity multiplicity;
        Class javaValueType;
        if (javaType instanceof Class) {
            javaValueType = (Class)javaType;
            multiplicity = Multiplicity.SINGLE;
        } else {
            if (!(javaType instanceof ParameterizedType)) throw new IllegalValueTypeException();
            ParameterizedType parameterizedType = (ParameterizedType)javaType;
            Type rawType = parameterizedType.getRawType();
            if (!(rawType instanceof Class)) throw new IllegalValueTypeException();
            Class classRawType = (Class)rawType;
            if (!List.class.equals((Object)classRawType)) throw new IllegalValueTypeException();
            Type elementType = parameterizedType.getActualTypeArguments()[0];
            if (!(elementType instanceof Class)) throw new IllegalValueTypeException();
            javaValueType = (Class)elementType;
            multiplicity = Multiplicity.MULTI;
        }
        if (javaValueType == String.class) {
            valueType = SimpleValueType.STRING;
        } else if (javaValueType == Integer.class || javaValueType == Integer.TYPE) {
            valueType = SimpleValueType.INTEGER;
        } else if (javaValueType == Boolean.class || javaValueType == Boolean.TYPE) {
            valueType = SimpleValueType.BOOLEAN;
        } else if (Enum.class.isAssignableFrom(javaValueType)) {
            valueType = SimpleValueType.ENUM;
        } else {
            if (!Value.class.isAssignableFrom(javaValueType)) throw new IllegalValueTypeException("Type " + javaValueType.getName() + " is not handled at the moment");
            valueType = SimpleValueType.VALUE;
        }
        if (completerType == EmptyCompleter.class) {
            completerType = valueType.getCompleter();
        }
        this.binding = binding;
        this.javaType = javaType;
        this.description = description;
        this.type = valueType;
        this.multiplicity = multiplicity;
        this.required = required;
        this.password = password;
        this.completerType = completerType;
        this.annotation = annotation;
        this.javaValueType = javaValueType;
        this.unquote = unquote;
    }

    public Object parse(String s) throws Exception {
        return this.type.parse(this.javaValueType, s);
    }

    public abstract Object parse(List<String> var1) throws CmdSyntaxException;

    public CommandDescriptor<?, B> getOwner() {
        return this.owner;
    }

    public Type getJavaType() {
        return this.javaType;
    }

    public Class<?> getJavaValueType() {
        return this.javaValueType;
    }

    public final B getBinding() {
        return this.binding;
    }

    public final String getUsage() {
        return this.description != null ? this.description.getUsage() : "";
    }

    public Description getDescription() {
        return this.description;
    }

    public Annotation getAnnotation() {
        return this.annotation;
    }

    public final boolean isRequired() {
        return this.required;
    }

    public boolean isUnquote() {
        return this.unquote;
    }

    public final boolean isPassword() {
        return this.password;
    }

    public final SimpleValueType getType() {
        return this.type;
    }

    public final Multiplicity getMultiplicity() {
        return this.multiplicity;
    }

    public final boolean isSingleValued() {
        return this.multiplicity == Multiplicity.SINGLE;
    }

    public final boolean isMultiValued() {
        return this.multiplicity == Multiplicity.MULTI;
    }

    public final Class<? extends Completer> getCompleterType() {
        return this.completerType;
    }

    public abstract void printUsage(Appendable var1) throws IOException;
}

