/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.cmdline.completers;

import java.util.HashSet;
import javax.naming.InitialContext;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.crsh.cmdline.ParameterDescriptor;
import org.crsh.cmdline.spi.Completer;
import org.crsh.cmdline.spi.ValueCompletion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JNDICompleter
implements Completer {
    private static HashSet<String> initJndicontextNames() {
        HashSet<String> contextNames = new HashSet<String>();
        contextNames.add("java:jboss/");
        contextNames.add("java:comp/env/jdbc");
        contextNames.add("java:/");
        contextNames.add("");
        return contextNames;
    }

    @Override
    public ValueCompletion complete(ParameterDescriptor<?> parameter, String prefix) throws Exception {
        if (null == prefix) {
            prefix = "";
        }
        return this.getJndiList(prefix);
    }

    ValueCompletion getJndiList(String prefix) {
        HashSet<String> contextNames = JNDICompleter.initJndicontextNames();
        if (prefix != null) {
            contextNames.add(prefix);
        }
        ValueCompletion completions = new ValueCompletion();
        for (String contextName : contextNames) {
            if (!contextName.endsWith("/")) {
                contextName = contextName + "/";
            }
            try {
                InitialContext ctx = new InitialContext();
                NamingEnumeration<NameClassPair> list = ctx.list(contextName);
                while (list.hasMore()) {
                    String jndiPath;
                    NameClassPair nc = list.next();
                    if (null == nc || (jndiPath = this.getJndiPath(contextName, nc.getName(), prefix)) == null) continue;
                    completions.put(jndiPath, false);
                }
            }
            catch (NamingException e1) {
            }
        }
        return completions;
    }

    public String getJndiPath(String contextName, String ncName, String prefix) {
        if (null == contextName || null == ncName || null == prefix) {
            throw new IllegalArgumentException("Argument(s) must not be null");
        }
        String result = ncName.isEmpty() ? contextName : contextName + ncName;
        if (!prefix.isEmpty()) {
            int prefixSize = prefix.length();
            int resultSize = result.length();
            String str = null;
            if (result.startsWith(prefix)) {
                if (prefixSize > 0 && resultSize > prefixSize) {
                    str = result.substring(prefixSize);
                }
            } else if (prefix.startsWith(result)) {
                if (resultSize > 0 && prefixSize < resultSize) {
                    str = prefix.substring(resultSize);
                }
            } else {
                str = null;
            }
            result = str;
        }
        return result;
    }
}

