/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.text;

import java.io.IOException;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import org.crsh.io.Pipe;
import org.crsh.text.CLS;
import org.crsh.text.Chunk;
import org.crsh.text.Style;
import org.crsh.text.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChunkBuffer
implements Iterable<Chunk>,
Serializable,
Pipe<Chunk> {
    private final LinkedList<Chunk> chunks = new LinkedList();
    private Style current = Style.style();
    private Style next = Style.style();
    private final Pipe<Chunk> out;

    public ChunkBuffer() {
        this.out = null;
    }

    public ChunkBuffer(Pipe<Chunk> out) {
        this.out = out;
    }

    @Override
    public Iterator<Chunk> iterator() {
        return this.chunks.iterator();
    }

    @Deprecated
    public void writeAnsiTo(Appendable appendable) throws IOException {
        for (Chunk chunk : this) {
            if (chunk instanceof Text) {
                Text text = (Text)chunk;
                if (text.buffer.length() <= 0) continue;
                appendable.append(text.buffer);
                continue;
            }
            if (!(chunk instanceof Style)) continue;
            ((Style)chunk).writeAnsiTo(appendable);
        }
    }

    public ChunkBuffer append(Iterable<?> data) throws NullPointerException {
        for (Object o : data) {
            this.append(o);
        }
        return this;
    }

    public ChunkBuffer append(Object ... data) throws NullPointerException {
        for (Object o : data) {
            this.append(o);
        }
        return this;
    }

    public ChunkBuffer cls() {
        this.chunks.addLast(CLS.INSTANCE);
        return this;
    }

    public ChunkBuffer append(Style style) throws NullPointerException {
        this.next = this.next.merge(style);
        return this;
    }

    public ChunkBuffer append(char c) {
        this.last().buffer.append(c);
        return this;
    }

    public ChunkBuffer append(CharSequence s) {
        return this.append(s, 0, s.length());
    }

    public ChunkBuffer append(CharSequence s, int start, int end) {
        if (end > start) {
            this.last().buffer.append(s, start, end);
        }
        return this;
    }

    private Text last() {
        Chunk last;
        if (!this.next.equals(this.current)) {
            if (!Style.style().equals(this.next)) {
                this.chunks.addLast(this.next);
            }
            this.current = this.next;
            this.next = Style.style();
        }
        if ((last = this.chunks.peekLast()) instanceof Text) {
            return (Text)last;
        }
        Text text = new Text();
        this.chunks.addLast(text);
        return text;
    }

    public Class<Chunk> getConsumedType() {
        return Chunk.class;
    }

    @Override
    public void provide(Chunk element) throws IOException {
        this.append((Object)element);
    }

    @Override
    public void flush() throws IOException {
        if (this.out != null) {
            for (Chunk chunk : this.chunks) {
                this.out.provide(chunk);
            }
        }
        this.chunks.clear();
        if (this.out != null) {
            this.out.flush();
        }
    }

    public ChunkBuffer append(ChunkBuffer s) throws NullPointerException {
        for (Chunk chunk : s.chunks) {
            this.write(chunk);
        }
        if (s.next != null && !s.next.equals(Style.style())) {
            this.write(s.next);
        }
        return this;
    }

    public void write(Chunk chunk) throws NullPointerException {
        if (chunk instanceof Style) {
            this.append((Style)chunk);
        } else if (chunk instanceof Text) {
            this.append(((Text)chunk).buffer);
        } else {
            this.cls();
        }
    }

    public ChunkBuffer append(Object o) throws NullPointerException {
        if (o == null) {
            throw new NullPointerException("No null accepted");
        }
        if (o instanceof ChunkBuffer) {
            this.append((ChunkBuffer)o);
        } else if (o instanceof Chunk) {
            this.write((Chunk)o);
        } else {
            CharSequence s = o instanceof CharSequence ? (CharSequence)o : o.toString();
            this.append(s);
        }
        return this;
    }

    public boolean contains(Object o) {
        return this.toString().contains(o.toString());
    }

    public boolean isEmpty() {
        return this.chunks.isEmpty();
    }

    public void clear() {
        this.chunks.clear();
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ChunkBuffer) {
            ChunkBuffer that = (ChunkBuffer)obj;
            return this.toString().equals(that.toString());
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Chunk chunk : this.chunks) {
            if (!(chunk instanceof Text)) continue;
            sb.append((CharSequence)((Text)chunk).buffer);
        }
        return sb.toString();
    }

    public void writeTo(Pipe<Chunk> writer) throws IOException {
        for (Chunk chunk : this.chunks) {
            writer.provide(chunk);
        }
    }
}

