/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.text.formatter;

import java.lang.management.MemoryUsage;
import org.crsh.text.Color;
import org.crsh.text.LineReader;
import org.crsh.text.RenderAppendable;
import org.crsh.text.Renderer;

public class MemoryUsageRenderer
extends Renderer {
    private final MemoryUsage usage;

    public MemoryUsageRenderer(MemoryUsage usage) {
        this.usage = usage;
    }

    public int getActualWidth() {
        return 32;
    }

    public int getMinWidth() {
        return 4;
    }

    public int getMinHeight(int width) {
        return 1;
    }

    public int getActualHeight(int width) {
        return 2;
    }

    public LineReader reader(int width) {
        return this.reader(width, 2);
    }

    public LineReader reader(final int width, final int height) {
        return new LineReader(){
            private int index = 0;

            public boolean hasLine() {
                return this.index < height;
            }

            public void renderLine(RenderAppendable to) throws IllegalStateException {
                if (!this.hasLine()) {
                    throw new IllegalStateException();
                }
                Color previous = null;
                for (int i = 0; i < width; ++i) {
                    long v = (long)i * MemoryUsageRenderer.this.usage.getMax() / (long)width;
                    Color current = v < MemoryUsageRenderer.this.usage.getInit() ? Color.black : (v < MemoryUsageRenderer.this.usage.getUsed() ? Color.red : (v < MemoryUsageRenderer.this.usage.getCommitted() ? Color.blue : Color.green));
                    if (previous != current) {
                        if (previous != null) {
                            to.leaveStyle();
                        }
                        to.enterStyle(current.bg());
                        previous = current;
                    }
                    to.append(' ');
                }
                if (previous != null) {
                    to.leaveStyle();
                }
                ++this.index;
            }
        };
    }
}

