/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.cmdline.completers;

import java.lang.reflect.Method;
import org.crsh.cmdline.ParameterDescriptor;
import org.crsh.cmdline.spi.Completer;
import org.crsh.cmdline.spi.Completion;
import org.crsh.cmdline.type.ValueType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumCompleter
implements Completer {
    private static final EnumCompleter instance = new EnumCompleter();

    public static EnumCompleter getInstance() {
        return instance;
    }

    @Override
    public Completion complete(ParameterDescriptor<?> parameter, String prefix) throws Exception {
        if (parameter.getType() == ValueType.ENUM) {
            Enum[] values;
            Completion.Builder builder = null;
            Class<?> vt = parameter.getDeclaredType();
            Method valuesM = vt.getDeclaredMethod("values", new Class[0]);
            Method nameM = vt.getMethod("name", new Class[0]);
            for (Enum value : values = (Enum[])valuesM.invoke(null, new Object[0])) {
                String name = (String)nameM.invoke((Object)value, new Object[0]);
                if (!name.startsWith(prefix)) continue;
                if (builder == null) {
                    builder = Completion.builder(prefix);
                }
                builder.add(name.substring(prefix.length()), true);
            }
            return builder != null ? builder.build() : Completion.create();
        }
        return Completion.create();
    }
}

