/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.ssh;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.logging.Level;
import org.apache.sshd.common.util.SecurityUtils;
import org.crsh.plugin.CRaSHPlugin;
import org.crsh.plugin.PropertyDescriptor;
import org.crsh.plugin.ResourceKind;
import org.crsh.ssh.term.SSHLifeCycle;
import org.crsh.vfs.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SSHPlugin
extends CRaSHPlugin<SSHPlugin> {
    public static final PropertyDescriptor<Integer> SSH_PORT = PropertyDescriptor.create((String)"ssh.port", (Integer)2000, (String)"The SSH port");
    public static final PropertyDescriptor<String> SSH_KEYPATH = PropertyDescriptor.create((String)"ssh.keypath", (String)null, (String)"The path to the key file");
    public static final PropertyDescriptor<String> AUTH = PropertyDescriptor.create((String)"auth", (String)null, (String)"The authentication plugin");
    private SSHLifeCycle lifeCycle;

    public SSHPlugin getImplementation() {
        return this;
    }

    protected Iterable<PropertyDescriptor<?>> createConfigurationCapabilities() {
        return Arrays.asList(SSH_PORT, SSH_KEYPATH, AUTH);
    }

    public void init() {
        String keyPath;
        Resource res;
        SecurityUtils.setRegisterBouncyCastle(true);
        Integer port = (Integer)this.getContext().getProperty(SSH_PORT);
        if (port == null) {
            this.log.log(Level.INFO, "Could not boot SSHD due to missing due to missing port configuration");
            return;
        }
        Resource key = null;
        URL keyURL = SSHPlugin.class.getResource("hostkey.pem");
        if (keyURL != null) {
            try {
                this.log.log(Level.FINE, "Found embedded key url " + keyURL);
                key = new Resource(keyURL);
            }
            catch (IOException e) {
                this.log.log(Level.FINE, "Could not load ssh key from url " + keyURL, e);
            }
        }
        if ((res = this.getContext().loadResource("hostkey.pem", ResourceKind.CONFIG)) != null) {
            key = res;
            this.log.log(Level.FINE, "Found ssh key url");
        }
        if ((keyPath = (String)this.getContext().getProperty(SSH_KEYPATH)) != null) {
            this.log.log(Level.FINE, "Found key path " + keyPath);
            File f = new File(keyPath);
            if (f.exists() && f.isFile()) {
                try {
                    keyURL = f.toURI().toURL();
                }
                catch (MalformedURLException e) {
                    this.log.log(Level.FINE, "Ignoring invalid key " + keyPath, e);
                }
            } else {
                this.log.log(Level.FINE, "Ignoring invalid key path " + keyPath);
            }
        }
        if (keyURL == null) {
            this.log.log(Level.INFO, "Could not boot SSHD due to missing key");
            return;
        }
        String authentication = (String)this.getContext().getProperty(AUTH);
        this.log.log(Level.INFO, "Booting SSHD");
        SSHLifeCycle lifeCycle = new SSHLifeCycle(this.getContext());
        lifeCycle.setPort(port);
        lifeCycle.setKey(key);
        lifeCycle.setAuthentication(authentication);
        lifeCycle.init();
        this.lifeCycle = lifeCycle;
    }

    public void destroy() {
        if (this.lifeCycle != null) {
            this.log.log(Level.INFO, "Shutting down SSHD");
            this.lifeCycle.destroy();
            this.lifeCycle = null;
        }
    }
}

