/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.shell.impl.command;

import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.crsh.command.CommandInvoker;
import org.crsh.command.NoSuchCommandException;
import org.crsh.command.ScriptException;
import org.crsh.command.ShellCommand;
import org.crsh.io.Filter;
import org.crsh.shell.ErrorType;
import org.crsh.shell.ShellProcessContext;
import org.crsh.shell.ShellResponse;
import org.crsh.shell.impl.command.CRaSHProcess;
import org.crsh.shell.impl.command.CRaSHSession;
import org.crsh.shell.impl.command.InvokerPipeFilter;
import org.crsh.shell.impl.command.PipeLine;
import org.crsh.shell.impl.command.ProcessInvocationContext;

public class PipeLineFactory {
    final String line;
    final String name;
    final String rest;
    final PipeLineFactory next;

    public String getLine() {
        return this.line;
    }

    PipeLineFactory(String line, PipeLineFactory next) {
        Pattern p = Pattern.compile("^\\s*(\\S+)");
        Matcher m = p.matcher(line);
        String name = null;
        String rest = null;
        if (m.find()) {
            name = m.group(1);
            rest = line.substring(m.end());
        }
        this.name = name;
        this.rest = rest;
        this.line = line;
        this.next = next;
    }

    public PipeLine create(CRaSHSession session) throws NoSuchCommandException {
        LinkedList pipes = new LinkedList();
        PipeLineFactory current = this;
        while (current != null) {
            ShellCommand command;
            CommandInvoker<?, ?> commandInvoker = null;
            if (current.name != null && (command = session.crash.getCommand(current.name)) != null) {
                commandInvoker = command.resolveInvoker(current.rest);
            }
            if (commandInvoker == null) {
                throw new NoSuchCommandException(current.name);
            }
            commandInvoker.setSession(session);
            pipes.add(new InvokerPipeFilter(commandInvoker));
            current = current.next;
        }
        return new PipeLine(session, pipes.toArray(new Filter[pipes.size()]));
    }

    PipeLineFactory getLast() {
        if (this.next != null) {
            return this.next.getLast();
        }
        return this;
    }

    CRaSHProcess create(final CRaSHSession session, String request) {
        return new CRaSHProcess(session, request){

            ShellResponse doInvoke(ShellProcessContext context) throws InterruptedException {
                PipeLine proxy;
                try {
                    proxy = PipeLineFactory.this.create(this.crash);
                }
                catch (NoSuchCommandException e) {
                    return ShellResponse.unknownCommand(e.getCommandName());
                }
                try {
                    proxy.invoke(new ProcessInvocationContext(session, context));
                }
                catch (ScriptException e) {
                    return PipeLineFactory.this.build(e);
                }
                catch (Throwable t) {
                    return PipeLineFactory.this.build(t);
                }
                return ShellResponse.ok();
            }
        };
    }

    private ShellResponse.Error build(Throwable throwable) {
        String result;
        ErrorType errorType;
        if (throwable instanceof ScriptException) {
            errorType = ErrorType.EVALUATION;
            Throwable cause = throwable.getCause();
            if (cause != null) {
                throwable = cause;
            }
        } else {
            errorType = ErrorType.INTERNAL;
        }
        String msg = throwable.getMessage();
        if (throwable instanceof ScriptException) {
            result = msg == null ? this.name + ": failed" : this.name + ": " + msg;
            return ShellResponse.error(errorType, result, throwable);
        }
        if (msg == null) {
            msg = throwable.getClass().getSimpleName();
        }
        result = throwable instanceof RuntimeException ? this.name + ": exception: " + msg : (throwable instanceof Exception ? this.name + ": exception: " + msg : (throwable instanceof Error ? this.name + ": error: " + msg : this.name + ": unexpected throwable: " + msg));
        return ShellResponse.error(errorType, result, throwable);
    }
}

