/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.vfs;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.crsh.util.BaseIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Path
implements Iterable<String> {
    private static final String[] EMPTY_STRING = new String[0];
    private final boolean dir;
    private final String[] names;
    private String value;

    public static Path get(Path parent, String name, boolean dir) {
        if (!parent.dir) {
            throw new IllegalArgumentException("Not a dir");
        }
        int length = parent.names.length;
        String[] names = new String[length + 1];
        System.arraycopy(parent.names, 0, names, 0, length);
        names[length] = name;
        return new Path(dir, names);
    }

    public static Path get(String s) {
        if (s.length() == 0) {
            throw new IllegalArgumentException("No empty path");
        }
        if (s.charAt(0) != '/') {
            throw new IllegalArgumentException("Path " + s + " must begin with a '/'");
        }
        int start = 0;
        int end = s.length();
        String[] names = EMPTY_STRING;
        while (start < end) {
            if (s.charAt(end - 1) == '/') {
                --end;
                continue;
            }
            if (s.charAt(start) == '/') {
                ++start;
                continue;
            }
            names = Path.parseNames(s, start, end, 0);
            break;
        }
        return new Path(end < s.length(), names);
    }

    private static String[] parseNames(String s, int prev, int end, int count) {
        int next = s.indexOf(47, prev);
        if (next == -1 || next > end) {
            if (prev < end) {
                String[] ret = new String[count + 1];
                ret[count] = s.substring(prev);
                return ret;
            }
            return new String[count];
        }
        if (next - prev > 0) {
            String[] ret = Path.parseNames(s, next + 1, end, count + 1);
            ret[count] = s.substring(prev, next);
            return ret;
        }
        return Path.parseNames(s, next + 1, end, count);
    }

    private Path(boolean dir, String[] names) {
        this.dir = dir;
        this.names = names;
    }

    @Override
    public Iterator<String> iterator() {
        return new BaseIterator<String>(){
            int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < Path.this.names.length;
            }

            @Override
            public String next() {
                if (this.index < Path.this.names.length) {
                    return Path.this.names[this.index++];
                }
                throw new NoSuchElementException();
            }
        };
    }

    public int getSize() {
        return this.names.length;
    }

    public boolean isDir() {
        return this.dir;
    }

    public String getName() {
        return this.names.length > 0 ? this.names[this.names.length - 1] : "";
    }

    public boolean isChildOf(Path parent) {
        int length;
        if (parent.dir && this.names.length == (length = parent.names.length) + 1) {
            for (int i = 0; i < length; ++i) {
                if (!this.names[i].equals(parent.names[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Path) {
            Path that = (Path)o;
            int length = that.names.length;
            if (this.names.length == length) {
                for (int i = 0; i < length; ++i) {
                    if (this.names[i].equals(that.names[i])) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int hashCode = this.dir ? 1 : 0;
        for (int i = this.names.length - 1; i >= 0; --i) {
            hashCode = hashCode * 41 + this.names[i].hashCode();
        }
        return hashCode;
    }

    public String getValue() {
        if (this.value == null) {
            StringBuilder sb = new StringBuilder(8 * this.names.length);
            for (String name : this.names) {
                sb.append('/').append(name);
            }
            if (this.dir) {
                sb.append('/');
            }
            this.value = sb.toString();
        }
        return this.value;
    }

    public String toString() {
        return "Path[value=" + this.getValue() + "]";
    }
}

