/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.ssh.term;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.sshd.common.PtyMode;
import org.apache.sshd.server.Environment;

public class SSHContext {
    private static final Logger log = Logger.getLogger(SSHContext.class.getName());
    public final int verase;
    private final Environment env;

    public SSHContext(Environment env) {
        if (env == null) {
            throw new NullPointerException("No null env");
        }
        Integer verase = (Integer)env.getPtyModes().get(PtyMode.VERASE);
        this.env = env;
        this.verase = verase != null ? verase : -1;
    }

    public int getWidth() {
        String s = (String)this.env.getEnv().get("COLUMNS");
        int width = 0;
        if (s != null) {
            try {
                width = Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                log.log(Level.WARNING, "Could not parse ssh term width " + s);
            }
        }
        return width;
    }

    public int getHeight() {
        String s = (String)this.env.getEnv().get("LINES");
        int height = 0;
        if (s != null) {
            try {
                height = Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                log.log(Level.WARNING, "Could not parse ssh term height " + s);
            }
        }
        return height;
    }

    public String getProperty(String key) {
        return (String)this.env.getEnv().get(key);
    }
}

