/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.shell.impl.command;

import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import groovy.lang.Script;
import java.io.Closeable;
import java.security.Principal;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.crsh.cli.impl.Delimiter;
import org.crsh.cli.impl.completion.CompletionMatch;
import org.crsh.cli.spi.Completion;
import org.crsh.command.BaseCommandContext;
import org.crsh.command.CommandContext;
import org.crsh.command.CommandInvoker;
import org.crsh.command.GroovyScriptCommand;
import org.crsh.command.NoSuchCommandException;
import org.crsh.command.ScriptException;
import org.crsh.command.ShellCommand;
import org.crsh.plugin.ResourceKind;
import org.crsh.shell.ErrorType;
import org.crsh.shell.Shell;
import org.crsh.shell.ShellProcess;
import org.crsh.shell.ShellProcessContext;
import org.crsh.shell.ShellResponse;
import org.crsh.shell.impl.command.CRaSH;
import org.crsh.shell.impl.command.CRaSHProcess;
import org.crsh.shell.impl.command.CRaSHProcessContext;
import org.crsh.shell.impl.command.PipeLineFactory;
import org.crsh.shell.impl.command.PipeLineParser;
import org.crsh.text.Chunk;
import org.crsh.util.Safe;
import org.crsh.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CRaSHSession
extends HashMap<String, Object>
implements Shell,
Closeable,
CommandContext {
    static final Logger log = Logger.getLogger(CRaSHSession.class.getName());
    static final Logger accessLog = Logger.getLogger("org.crsh.shell.access");
    private GroovyShell groovyShell;
    final CRaSH crash;
    final Principal user;

    public GroovyShell getGroovyShell() {
        if (this.groovyShell == null) {
            CompilerConfiguration config = new CompilerConfiguration();
            config.setRecompileGroovySource(true);
            config.setScriptBaseClass(GroovyScriptCommand.class.getName());
            this.groovyShell = new GroovyShell(this.crash.context.getLoader(), new Binding((Map)this), config);
        }
        return this.groovyShell;
    }

    public Script getLifeCycle(String name) throws NoSuchCommandException, NullPointerException {
        Class<Script> scriptClass = this.crash.lifecycles.getClass(name);
        if (scriptClass != null) {
            Script script = InvokerHelper.createScript(scriptClass, (Binding)new Binding((Map)this));
            script.setBinding(new Binding((Map)this));
            return script;
        }
        return null;
    }

    CRaSHSession(CRaSH crash, Principal user) {
        this.put("crash", crash);
        this.groovyShell = null;
        this.crash = crash;
        this.user = user;
        try {
            Script login = this.getLifeCycle("login");
            if (login instanceof CommandInvoker) {
                ((CommandInvoker)login).setSession(this);
            }
            if (login != null) {
                login.run();
            }
        }
        catch (NoSuchCommandException e) {
            e.printStackTrace();
        }
    }

    @Override
    public Map<String, Object> getSession() {
        return this;
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.crash.context.getAttributes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        ClassLoader previous = this.setCRaSHLoader();
        try {
            Script logout = this.getLifeCycle("logout");
            if (logout instanceof CommandInvoker) {
                ((CommandInvoker)logout).setSession(this);
            }
            if (logout != null) {
                logout.run();
            }
        }
        catch (NoSuchCommandException e) {
            e.printStackTrace();
        }
        finally {
            this.setPreviousLoader(previous);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getWelcome() {
        ClassLoader previous = this.setCRaSHLoader();
        try {
            GroovyShell shell = this.getGroovyShell();
            Object ret = shell.evaluate("welcome();");
            String string = String.valueOf(ret);
            return string;
        }
        finally {
            this.setPreviousLoader(previous);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getPrompt() {
        ClassLoader previous = this.setCRaSHLoader();
        try {
            GroovyShell shell = this.getGroovyShell();
            Object ret = shell.evaluate("prompt();");
            String string = String.valueOf(ret);
            return string;
        }
        finally {
            this.setPreviousLoader(previous);
        }
    }

    @Override
    public ShellProcess createProcess(String request) {
        ShellResponse response;
        log.log(Level.FINE, "Invoking request " + request);
        if ("bye".equals(request) || "exit".equals(request)) {
            response = ShellResponse.close();
        } else {
            PipeLineParser parser = new PipeLineParser(request);
            PipeLineFactory factory = parser.parse();
            if (factory != null) {
                try {
                    final CommandInvoker<Void, Chunk> pipeLine = factory.create(this);
                    return new CRaSHProcess(this, request){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        ShellResponse doInvoke(ShellProcessContext context) throws InterruptedException {
                            CRaSHProcessContext invocationContext = new CRaSHProcessContext(CRaSHSession.this, context);
                            try {
                                pipeLine.open(invocationContext);
                                pipeLine.flush();
                                ShellResponse.Ok ok = ShellResponse.ok();
                                return ok;
                            }
                            catch (ScriptException e) {
                                ShellResponse.Error error = this.build(e);
                                return error;
                            }
                            catch (Throwable t) {
                                ShellResponse.Error error = this.build(t);
                                return error;
                            }
                            finally {
                                Safe.close(pipeLine);
                                Safe.close(invocationContext);
                            }
                        }

                        private ShellResponse.Error build(Throwable throwable) {
                            String result;
                            ErrorType errorType;
                            if (throwable instanceof ScriptException) {
                                errorType = ErrorType.EVALUATION;
                                Throwable cause = throwable.getCause();
                                if (cause != null) {
                                    throwable = cause;
                                }
                            } else {
                                errorType = ErrorType.INTERNAL;
                            }
                            String msg = throwable.getMessage();
                            if (throwable instanceof ScriptException) {
                                result = msg == null ? this.request + ": failed" : this.request + ": " + msg;
                                return ShellResponse.error(errorType, result, throwable);
                            }
                            if (msg == null) {
                                msg = throwable.getClass().getSimpleName();
                            }
                            result = throwable instanceof RuntimeException ? this.request + ": exception: " + msg : (throwable instanceof Exception ? this.request + ": exception: " + msg : (throwable instanceof Error ? this.request + ": error: " + msg : this.request + ": unexpected throwable: " + msg));
                            return ShellResponse.error(errorType, result, throwable);
                        }
                    };
                }
                catch (NoSuchCommandException e) {
                    response = ShellResponse.unknownCommand(e.getCommandName());
                }
            } else {
                response = ShellResponse.noCommand();
            }
        }
        return new CRaSHProcess(this, request){

            ShellResponse doInvoke(ShellProcessContext context) throws InterruptedException {
                return response;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletionMatch complete(String prefix) {
        ClassLoader previous = this.setCRaSHLoader();
        try {
            CompletionMatch completion;
            String termPrefix;
            log.log(Level.FINE, "Want prefix of " + prefix);
            PipeLineFactory ast = new PipeLineParser(prefix).parse();
            if (ast != null) {
                PipeLineFactory last = ast.getLast();
                termPrefix = Utils.trimLeft(last.getLine());
            } else {
                termPrefix = "";
            }
            log.log(Level.FINE, "Retained term prefix is " + prefix);
            int pos = termPrefix.indexOf(32);
            if (pos == -1) {
                Completion.Builder builder = Completion.builder((String)prefix);
                for (String resourceId : this.crash.context.listResourceId(ResourceKind.COMMAND)) {
                    if (!resourceId.startsWith(termPrefix)) continue;
                    builder.add(resourceId.substring(termPrefix.length()), true);
                }
                completion = new CompletionMatch(Delimiter.EMPTY, builder.build());
            } else {
                String commandName = termPrefix.substring(0, pos);
                termPrefix = termPrefix.substring(pos);
                try {
                    ShellCommand command = this.crash.getCommand(commandName);
                    completion = command != null ? command.complete(new BaseCommandContext(this, this.crash.context.getAttributes()), termPrefix) : new CompletionMatch(Delimiter.EMPTY, Completion.create());
                }
                catch (NoSuchCommandException e) {
                    log.log(Level.FINE, "Could not create command for completion of " + prefix, e);
                    completion = new CompletionMatch(Delimiter.EMPTY, Completion.create());
                }
            }
            log.log(Level.FINE, "Found completions for " + prefix + ": " + completion);
            CompletionMatch completionMatch = completion;
            return completionMatch;
        }
        finally {
            this.setPreviousLoader(previous);
        }
    }

    ClassLoader setCRaSHLoader() {
        Thread thread = Thread.currentThread();
        ClassLoader previous = thread.getContextClassLoader();
        thread.setContextClassLoader(this.crash.context.getLoader());
        return previous;
    }

    void setPreviousLoader(ClassLoader previous) {
        Thread.currentThread().setContextClassLoader(previous);
    }
}

