/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.shell.impl.command;

import java.io.IOException;
import org.crsh.command.ScriptException;
import org.crsh.io.Filter;
import org.crsh.shell.InteractionContext;
import org.crsh.shell.ScreenContext;
import org.crsh.text.Chunk;
import org.crsh.text.ChunkAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class Pipe<C, P>
implements Filter<C, P, InteractionContext<P>>,
InteractionContext<C> {
    protected InteractionContext<P> context;

    Pipe() {
    }

    @Override
    public final boolean takeAlternateBuffer() throws IOException {
        return this.context.takeAlternateBuffer();
    }

    @Override
    public final boolean releaseAlternateBuffer() throws IOException {
        return this.context.releaseAlternateBuffer();
    }

    @Override
    public final String getProperty(String propertyName) {
        return this.context.getProperty(propertyName);
    }

    @Override
    public final String readLine(String msg, boolean echo) {
        return this.context.readLine(msg, echo);
    }

    @Override
    public final int getWidth() {
        return this.context.getWidth();
    }

    @Override
    public final int getHeight() {
        return this.context.getHeight();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Sink<P>
    extends Pipe<Object, P> {
        private final Class<P> producedType;

        Sink(Class<P> producedType) {
            this.producedType = producedType;
        }

        @Override
        public Class<P> getProducedType() {
            return this.producedType;
        }

        @Override
        public void setPiped(boolean piped) {
        }

        @Override
        public void open(InteractionContext<P> consumer) {
            this.context = consumer;
        }

        @Override
        public void provide(Object element) throws IOException {
        }

        @Override
        public Class<Object> getConsumedType() {
            return Object.class;
        }

        @Override
        public void flush() throws IOException {
            this.context.flush();
        }

        @Override
        public void close() {
            ((Pipe)this.context).close();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Chunkizer
    extends Pipe<Object, Chunk> {
        private ChunkAdapter ca;

        Chunkizer() {
        }

        @Override
        public Class<Chunk> getProducedType() {
            return Chunk.class;
        }

        @Override
        public Class<Object> getConsumedType() {
            return Object.class;
        }

        @Override
        public void setPiped(boolean piped) {
            ((Pipe)this.context).setPiped(piped);
        }

        @Override
        public void open(final InteractionContext<Chunk> consumer) {
            this.ca = new ChunkAdapter(new ScreenContext<Chunk>(){

                @Override
                public int getWidth() {
                    return consumer.getWidth();
                }

                @Override
                public int getHeight() {
                    return consumer.getHeight();
                }

                @Override
                public Class<Chunk> getConsumedType() {
                    return Chunk.class;
                }

                @Override
                public void provide(Chunk element) throws IOException {
                    Chunkizer.this.context.provide(element);
                }

                @Override
                public void flush() throws IOException {
                    Chunkizer.this.context.flush();
                }
            });
            this.context = consumer;
        }

        @Override
        public void provide(Object element) throws ScriptException, IOException {
            this.ca.provide(element);
        }

        @Override
        public void flush() throws ScriptException, IOException {
            this.ca.flush();
        }

        @Override
        public void close() throws ScriptException {
            ((Pipe)this.context).close();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Invoker<C, P>
    extends Pipe<C, P> {
        final Filter<C, P, InteractionContext<P>> command;

        Invoker(Filter<C, P, InteractionContext<P>> command) {
            this.command = command;
        }

        @Override
        public void setPiped(boolean piped) {
            this.command.setPiped(piped);
        }

        @Override
        public Class<P> getProducedType() {
            return this.command.getProducedType();
        }

        @Override
        public Class<C> getConsumedType() {
            return this.command.getConsumedType();
        }

        @Override
        public void open(InteractionContext<P> consumer) {
            this.context = consumer;
            this.command.open(consumer);
        }

        @Override
        public void provide(C element) throws IOException {
            if (this.command.getConsumedType().isInstance(element)) {
                this.command.provide(element);
            }
        }

        @Override
        public void flush() throws IOException {
            this.command.flush();
        }

        @Override
        public void close() throws ScriptException {
            this.command.close();
        }
    }
}

