/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.term.console;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import org.crsh.term.spi.TermIO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class TermIOBuffer
implements Appendable,
Iterator<CharSequence> {
    private char[] buffer = new char[128];
    private int size = 0;
    private int curAt = 0;
    private LinkedList<CharSequence> lines = new LinkedList();
    private boolean previousCR = false;
    private boolean echoing = true;
    private final TermIO io;

    TermIOBuffer(TermIO io) {
        this.io = io;
    }

    void clear() {
        this.previousCR = false;
        this.curAt = 0;
        this.size = 0;
    }

    int getSize() {
        return this.size;
    }

    int getCursor() {
        return this.curAt;
    }

    char charAt(int index) throws IndexOutOfBoundsException {
        if (index < 0) {
            throw new IndexOutOfBoundsException("No negative position accepted");
        }
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Cannot accept position greater than size:" + index + " >= " + this.size);
        }
        return this.buffer[index];
    }

    CharSequence getBufferToCursor() {
        return new String(this.buffer, 0, this.curAt);
    }

    boolean isEchoing() {
        return this.echoing;
    }

    void setEchoing(boolean echoing) {
        this.echoing = echoing;
    }

    @Override
    public boolean hasNext() {
        return this.lines.size() > 0;
    }

    @Override
    public CharSequence next() {
        if (this.lines.size() > 0) {
            return this.lines.removeFirst();
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public TermIOBuffer append(char c) throws IOException {
        if (this.appendData(c)) {
            this.io.flush();
        }
        return this;
    }

    @Override
    public TermIOBuffer append(CharSequence s) throws IOException {
        return this.append(s, 0, s.length());
    }

    @Override
    public TermIOBuffer append(CharSequence csq, int start, int end) throws IOException {
        if (this.appendData(csq, start, end)) {
            this.io.flush();
        }
        return this;
    }

    CharSequence replace(CharSequence s) throws IOException {
        StringBuilder builder = new StringBuilder();
        boolean flush = false;
        int i = this.appendDel();
        while (i != -1) {
            builder.append((char)i);
            flush = true;
            i = this.appendDel();
        }
        if (flush |= this.appendData(s, 0, s.length())) {
            this.io.flush();
        }
        return builder.reverse().toString();
    }

    boolean moveRight() throws IOException {
        return this.moveRight(1) == 1;
    }

    boolean moveLeft() throws IOException {
        return this.moveLeft(1) == 1;
    }

    int moveRight(int count) throws IOException, IllegalArgumentException {
        int delta;
        if (count < 0) {
            throw new IllegalArgumentException("Cannot move with negative count " + count);
        }
        for (delta = 0; delta < count && this.curAt + delta < this.size && this.io.moveRight(this.buffer[this.curAt + delta]); ++delta) {
        }
        if (delta > 0) {
            this.io.flush();
            this.curAt += delta;
        }
        return delta;
    }

    int moveLeft(int count) throws IOException, IllegalArgumentException {
        int delta;
        if (count < 0) {
            throw new IllegalArgumentException("Cannot move with negative count " + count);
        }
        for (delta = 0; delta < count && delta < this.curAt && this.io.moveLeft(); ++delta) {
        }
        if (delta > 0) {
            this.io.flush();
            this.curAt -= delta;
        }
        return delta;
    }

    int del() throws IOException {
        int ret = this.appendDel();
        if (ret != -1) {
            this.io.flush();
        }
        return ret;
    }

    private boolean appendData(CharSequence s, int start, int end) throws IOException {
        if (start < 0) {
            throw new IndexOutOfBoundsException("No negative start");
        }
        if (end < 0) {
            throw new IndexOutOfBoundsException("No negative end");
        }
        if (end > s.length()) {
            throw new IndexOutOfBoundsException("End cannot be greater than sequence length");
        }
        if (end < start) {
            throw new IndexOutOfBoundsException("Start cannot be greater than end");
        }
        boolean flush = false;
        for (int i = start; i < end; ++i) {
            flush |= this.appendData(s.charAt(i));
        }
        return flush;
    }

    private boolean appendData(char c) throws IOException {
        if (this.previousCR && c == '\n') {
            this.previousCR = false;
            return false;
        }
        if (c == '\r' || c == '\n') {
            this.previousCR = c == '\r';
            String line = new String(this.buffer, 0, this.size);
            this.lines.add(line);
            this.curAt = this.size = 0;
            return this.echoCRLF();
        }
        if (this.push(c)) {
            return this.echo(c);
        }
        String disp = new String(this.buffer, this.curAt, this.size - this.curAt);
        this.io.write(disp);
        ++this.curAt;
        for (int amount = this.size - this.curAt - 1; amount > 0; --amount) {
            this.io.moveLeft();
        }
        return true;
    }

    private int appendDel() throws IOException {
        if (this.curAt == this.size) {
            int popped = this.pop();
            if (popped != -1) {
                this.echoDel();
            }
            return popped;
        }
        int popped = this.pop();
        if (popped != -1) {
            if (this.io.moveLeft()) {
                StringBuilder disp = new StringBuilder();
                disp.append(this.buffer, this.curAt, this.size - this.curAt);
                disp.append(' ');
                this.io.write(disp);
                for (int amount = this.size - this.curAt + 1; amount > 0; --amount) {
                    this.io.moveLeft();
                }
            } else {
                throw new UnsupportedOperationException("not implemented");
            }
        }
        return popped;
    }

    private boolean echo(char c) throws IOException {
        if (this.echoing) {
            this.io.write(c);
            return true;
        }
        return false;
    }

    private void echo(String s) throws IOException {
        if (this.echoing) {
            this.io.write(s);
            this.io.flush();
        }
    }

    private boolean echoDel() throws IOException {
        if (this.echoing) {
            this.io.writeDel();
            return true;
        }
        return false;
    }

    private boolean echoCRLF() throws IOException {
        if (this.echoing) {
            this.io.writeCRLF();
            return true;
        }
        return false;
    }

    private int pop() {
        if (this.curAt > 0) {
            char popped = this.buffer[this.curAt - 1];
            if (this.curAt == this.size) {
                this.buffer[this.curAt] = '\u0000';
                this.size = --this.curAt;
                return popped;
            }
            for (int i = this.curAt; i < this.size; ++i) {
                this.buffer[i - 1] = this.buffer[i];
            }
            this.buffer[--this.size] = '\u0000';
            --this.curAt;
            return popped;
        }
        return -1;
    }

    private boolean push(char c) {
        if (this.size >= this.buffer.length) {
            char[] tmp = new char[this.buffer.length * 2 + 1];
            System.arraycopy(this.buffer, 0, tmp, 0, this.buffer.length);
            this.buffer = tmp;
        }
        if (this.curAt == this.size) {
            this.buffer[this.size++] = c;
            ++this.curAt;
            return true;
        }
        for (int i = this.size - 1; i > this.curAt - 1; --i) {
            this.buffer[i + 1] = this.buffer[i];
        }
        this.buffer[this.curAt] = c;
        ++this.size;
        return false;
    }
}

