/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.text.formatter;

import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.crsh.text.Color;
import org.crsh.text.Decoration;
import org.crsh.text.Renderable;
import org.crsh.text.Renderer;
import org.crsh.text.ui.LabelElement;
import org.crsh.text.ui.RowElement;
import org.crsh.text.ui.TableElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoggerRenderable
extends Renderable<Logger> {
    @Override
    public Class<Logger> getType() {
        return Logger.class;
    }

    @Override
    public Renderer renderer(Iterator<Logger> stream) {
        TableElement table = new TableElement();
        RowElement header = new RowElement();
        header.style(Decoration.bold.fg(Color.black).bg(Color.white));
        header.add(new LabelElement("NAME"));
        header.add(new LabelElement("LEVEL"));
        table.add(header);
        while (stream.hasNext()) {
            Logger logger = stream.next();
            String level = logger.isLoggable(Level.FINER) ? "TRACE" : (logger.isLoggable(Level.FINE) ? "DEBUG" : (logger.isLoggable(Level.INFO) ? "INFO" : (logger.isLoggable(Level.WARNING) ? "WARN" : (logger.isLoggable(Level.SEVERE) ? "ERROR" : "UNKNOWN"))));
            RowElement row = new RowElement();
            row.add(new LabelElement(logger.getName()));
            row.add(new LabelElement(level));
            table.add(row);
        }
        return table.renderer();
    }
}

