/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.cli.completers;

import java.util.Collection;
import org.crsh.cli.descriptor.ParameterDescriptor;
import org.crsh.cli.spi.Completer;
import org.crsh.cli.spi.Completion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPathCompleter<P>
implements Completer {
    protected abstract String getCurrentPath() throws Exception;

    protected abstract P getPath(String var1) throws Exception;

    protected abstract boolean exists(P var1) throws Exception;

    protected abstract boolean isDirectory(P var1) throws Exception;

    protected abstract boolean isFile(P var1) throws Exception;

    protected abstract Collection<P> getChilren(P var1) throws Exception;

    protected abstract String getName(P var1) throws Exception;

    @Override
    public final Completion complete(ParameterDescriptor parameter, String prefix) throws Exception {
        P f;
        if (!prefix.startsWith("/")) {
            String currentPath = this.getCurrentPath();
            if (!currentPath.endsWith("/")) {
                currentPath = currentPath + "/";
            }
            prefix = prefix.length() > 0 ? currentPath + prefix : currentPath;
        }
        if (this.exists(f = this.getPath(prefix))) {
            if (this.isDirectory(f)) {
                if (prefix.endsWith("/")) {
                    Collection<P> children = this.getChilren(f);
                    if (children != null) {
                        if (children.size() > 0) {
                            return this.listDir(f, "");
                        }
                        return Completion.create();
                    }
                    return Completion.create();
                }
                Collection<P> children = this.getChilren(f);
                if (children == null) {
                    return Completion.create();
                }
                return Completion.create("/", false);
            }
            if (this.isFile(f)) {
                return Completion.create("", true);
            }
            return Completion.create();
        }
        int pos = prefix.lastIndexOf(47);
        if (pos != -1) {
            String filter;
            if (pos == 0) {
                f = this.getPath("/");
                filter = prefix.substring(1);
            } else {
                f = this.getPath(prefix.substring(0, pos));
                filter = prefix.substring(pos + 1);
            }
            if (this.exists(f)) {
                if (this.isDirectory(f)) {
                    return this.listDir(f, filter);
                }
                return Completion.create();
            }
            return Completion.create();
        }
        return Completion.create();
    }

    private Completion listDir(P dir, String filter) throws Exception {
        Collection<P> children = this.getChilren(dir);
        if (children != null) {
            Completion.Builder builder = Completion.builder(filter);
            for (P child : children) {
                String name = this.getName(child);
                if (!name.startsWith(filter)) continue;
                String suffix = name.substring(filter.length());
                if (this.isDirectory(child)) {
                    Collection<P> grandChildren = this.getChilren(child);
                    if (grandChildren == null) continue;
                    builder.add(suffix + "/", false);
                    continue;
                }
                builder.add(suffix, true);
            }
            return builder.build();
        }
        return Completion.create();
    }
}

