/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.cli.impl.completion;

import org.crsh.cli.completers.EmptyCompleter;
import org.crsh.cli.descriptor.ParameterDescriptor;
import org.crsh.cli.impl.Delimiter;
import org.crsh.cli.impl.completion.Completion;
import org.crsh.cli.impl.completion.CompletionException;
import org.crsh.cli.impl.completion.CompletionMatch;
import org.crsh.cli.spi.Completer;

class ParameterCompletion
extends Completion {
    private final String prefix;
    private final Delimiter delimiter;
    private final ParameterDescriptor parameter;
    private final Completer completer;

    public ParameterCompletion(String prefix, Delimiter delimiter, ParameterDescriptor parameter, Completer completer) {
        this.prefix = prefix;
        this.delimiter = delimiter;
        this.parameter = parameter;
        this.completer = completer;
    }

    public CompletionMatch complete() throws CompletionException {
        Class<? extends Completer> completerType = this.parameter.getCompleterType();
        Completer completer = this.completer;
        if (completerType != EmptyCompleter.class) {
            try {
                completer = completerType.newInstance();
            }
            catch (Exception e) {
                throw new CompletionException(e);
            }
        }
        if (completer != null) {
            try {
                return new CompletionMatch(this.delimiter, completer.complete(this.parameter, this.prefix));
            }
            catch (Exception e) {
                throw new CompletionException(e);
            }
        }
        return new CompletionMatch(this.delimiter, org.crsh.cli.spi.Completion.create());
    }
}

