/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.cli.impl.tokenizer;

public abstract class Token {
    final int index;
    final String raw;

    Token(int index, String raw) {
        if (index < 0) {
            throw new IllegalArgumentException();
        }
        if (raw == null) {
            throw new NullPointerException();
        }
        this.index = index;
        this.raw = raw;
    }

    public String getRaw() {
        return this.raw;
    }

    public int getFrom() {
        return this.index;
    }

    public int getTo() {
        return this.index + this.raw.length();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Token) {
            Token that = (Token)obj;
            return this.index == that.index && this.raw.equals(that.raw);
        }
        return false;
    }

    public static abstract class Literal
    extends Token {
        final String value;

        Literal(int index, String value) {
            this(index, value, value);
        }

        Literal(int index, String raw, String value) {
            super(index, raw);
            if (value == null) {
                throw new NullPointerException();
            }
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj.getClass().equals(this.getClass())) {
                Literal that = (Literal)obj;
                return super.equals(obj) && this.index == that.index && this.value.equals(that.value);
            }
            return false;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[index=" + this.index + ",raw=" + this.raw + ",value=" + this.value + "]";
        }

        public static final class Word
        extends Literal {
            public Word(int index, String raw, String value) {
                super(index, raw, value);
            }

            public Word(int index, String value) {
                super(index, value);
            }
        }

        public static abstract class Option
        extends Literal {
            private final String name;

            public final String getName() {
                return this.name;
            }

            Option(int index, String raw, String value, String name) {
                super(index, raw, value);
                this.name = name;
            }

            public static final class Long
            extends Option {
                public Long(int index, String value) {
                    this(index, value, value);
                }

                public Long(int index, String raw, String value) {
                    super(index, raw, value, value.substring(2));
                }
            }

            public static final class Short
            extends Option {
                public Short(int index, String raw, String value) {
                    super(index, raw, value, value.substring(1));
                }

                public Short(int index, String value) {
                    this(index, value, value);
                }
            }
        }
    }

    public static final class Whitespace
    extends Token {
        public Whitespace(int index, String raw) {
            super(index, raw);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Whitespace) {
                Whitespace that = (Whitespace)obj;
                return super.equals(obj) && this.index == that.index;
            }
            return false;
        }

        public String toString() {
            return "Token.Whitespace[index=" + this.index + ",raw=" + this.raw + "]";
        }
    }
}

